/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import java.util.HashMap;
import java.util.Map;

final class DirectoryCache {
    private final CrowdDirectoryService directoryService;
    private final Map<Long, Directory> cache;

    DirectoryCache(CrowdDirectoryService directoryService) {
        this.directoryService = directoryService;
        this.cache = new HashMap<Long, Directory>();
    }

    String getDirectoryName(User user) {
        Directory directory;
        if (user != null && (directory = this.getDirectory(user)) != null) {
            return directory.getName();
        }
        return "";
    }

    boolean isReadOnly(User user) {
        Directory directory;
        if (user != null && (directory = this.getDirectory(user)) != null) {
            return !directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
        }
        return true;
    }

    private Directory getDirectory(User user) {
        Directory directory = this.cache.get(user.getDirectoryId());
        if (directory == null && (directory = this.directoryService.findDirectoryById(user.getDirectoryId())) != null) {
            this.cache.put(directory.getId(), directory);
        }
        return directory;
    }
}

