/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.GroupMembershipQuery;
import com.atlassian.crowd.search.query.membership.UserMembersOfGroupQuery;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.crowd.AllowedDirectoryOperations;
import com.atlassian.stash.crowd.CrowdAdminService;
import com.atlassian.stash.crowd.CrowdGroup;
import com.atlassian.stash.crowd.CrowdUser;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.InvalidTokenException;
import com.atlassian.stash.exception.LicenseLimitException;
import com.atlassian.stash.exception.NoMailHostConfigurationException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.OperationNotPermittedException;
import com.atlassian.stash.exception.SendingEmailException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.DirectoryCache;
import com.atlassian.stash.internal.crowd.EmailNotifier;
import com.atlassian.stash.internal.crowd.GroupMatchingFilter;
import com.atlassian.stash.internal.crowd.PasswordResetHelper;
import com.atlassian.stash.internal.crowd.UserMatchingFilter;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@AvailableToPlugins(value=CrowdAdminService.class)
@Transactional(readOnly=true)
public class CrowdAdminServiceImpl
implements CrowdAdminService {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdAdminServiceImpl.class);
    private final CrowdService crowdService;
    private final CrowdDirectoryService directoryService;
    private final PermissionAdminService permissionAdminService;
    private final SecureTokenGenerator tokenGenerator;
    private final PasswordResetHelper passwordResetHelper;
    private final EmailNotifier emailNotifier;
    private final LicenseService licenseService;
    private final I18nService i18nService;
    private final PersistentTokenRepository tokenRepository;
    private static final Function<User, CrowdUser> USER_TRANSFORM = new Function<User, CrowdUser>(){

        public CrowdUser apply(User user) {
            return new CrowdUser(user, null, null);
        }
    };

    @Autowired
    public CrowdAdminServiceImpl(CrowdService crowdService, @Qualifier(value="publicCrowdDirectoryService") CrowdDirectoryService directoryService, PermissionAdminService permissionAdminService, PasswordResetHelper passwordResetHelper, EmailNotifier emailNotifier, LicenseService licenseService, I18nService i18nService, SecureTokenGenerator tokenGenerator, PersistentTokenRepository tokenRepository) {
        this.crowdService = crowdService;
        this.directoryService = directoryService;
        this.permissionAdminService = permissionAdminService;
        this.tokenGenerator = tokenGenerator;
        this.passwordResetHelper = passwordResetHelper;
        this.emailNotifier = emailNotifier;
        this.licenseService = licenseService;
        this.i18nService = i18nService;
        this.tokenRepository = tokenRepository;
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public CrowdUser findUser(@Nonnull String name) {
        User user = this.crowdService.getUser(name);
        return user == null ? null : new CrowdUser(user, null, null);
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public CrowdUser findUserWithDirectoryInfo(@Nonnull String userName) {
        User user = this.crowdService.getUser(userName);
        if (user == null) {
            return null;
        }
        DirectoryCache cache = new DirectoryCache(this.directoryService);
        return new CrowdUser(user, cache.getDirectoryName(user), Boolean.valueOf(cache.isReadOnly(user)));
    }

    @Nonnull
    @Unsecured(value="Determining which Crowd operations are permitted does not require a specific permission")
    public AllowedDirectoryOperations getAllowedOperationsForDirectoryContaining(@Nonnull String name) {
        User user = this.crowdService.getUser(name);
        if (user == null) {
            return new AllowedDirectoryOperationsImpl(false, false);
        }
        Directory directory = this.directoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            LOG.warn("Permitted mutations: Couldn't find the directory of the user: " + name);
            return new AllowedDirectoryOperationsImpl(false, false);
        }
        Set allowedOps = directory.getAllowedOperations();
        return new AllowedDirectoryOperationsImpl(allowedOps.contains(OperationType.UPDATE_USER), allowedOps.contains(OperationType.UPDATE_GROUP));
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#name, 'SYS_ADMIN'))")
    public CrowdUser updateUserDetails(@Nonnull String name, @Nonnull String displayName, @Nonnull String email) {
        User user = this.validateUserExists(name);
        User update = ImmutableUser.newUser((User)user).displayName(displayName).emailAddress(email).toUser();
        try {
            return new CrowdUser(this.crowdService.updateUser(update));
        }
        catch (InvalidUserException e) {
            throw this.canNotUpdateUser(name, (Exception)((Object)e));
        }
        catch (com.atlassian.crowd.exception.OperationNotPermittedException e) {
            throw this.canNotUpdateUser(name, (Exception)((Object)e));
        }
        catch (OperationFailedException e) {
            throw this.canNotUpdateUser(name, (Exception)((Object)e));
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#name, 'SYS_ADMIN'))")
    public void updateUserPassword(@Nonnull String name, @Nonnull String newPassword) {
        User user = this.validateUserExists(name);
        try {
            this.passwordResetHelper.resetPassword(user, newPassword);
        }
        catch (InvalidCredentialException e) {
            throw this.canNotUpdateUser(name, (Exception)((Object)e));
        }
        catch (com.atlassian.crowd.exception.OperationNotPermittedException e) {
            throw this.canNotUpdateUser(name, (Exception)((Object)e));
        }
        catch (OperationFailedException e) {
            throw this.canNotUpdateUser(name, (Exception)((Object)e));
        }
    }

    private ServerException canNotUpdateUser(String name, Exception e) {
        KeyedMessage keyedText = this.i18nService.getKeyedText("stash.service.users.canNotUpdate", "The user {0} could not be updated: {1}", new Object[]{name, Throwables.getRootCause((Throwable)e).getLocalizedMessage()});
        if (LOG.isDebugEnabled()) {
            LOG.debug(keyedText.getLocalisedMessage(), (Throwable)e);
        }
        throw new ServerException(keyedText, (Throwable)e);
    }

    @Nonnull
    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<CrowdUser> findUsers(@Nonnull PageRequest pageRequest) {
        return StringUtils.isBlank((String)pageRequest.getFilter()) ? this.findAllUsers(pageRequest) : this.findMatchingUsers(pageRequest);
    }

    private Page<CrowdUser> findAllUsers(PageRequest pageRequest) {
        int limit;
        Iterable users;
        int start = pageRequest.getStart();
        return this.asUserPage(pageRequest, users, Iterables.size((Iterable)(users = this.crowdService.search((Query)new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, start, limit = pageRequest.getLimit() + 1)))) <= pageRequest.getLimit());
    }

    private Page<CrowdUser> findMatchingUsers(PageRequest pageRequest) {
        String filter = pageRequest.getFilter();
        UserMatchingFilter<User> userFilter = new UserMatchingFilter<User>(this.crowdService, filter){

            @Override
            Query<User> getQuery(String filter, int offset, int limit) {
                BooleanRestriction restriction = Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)filter), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)filter), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)filter)});
                return new UserQuery(User.class, (SearchRestriction)restriction, offset, limit);
            }
        };
        Page users = userFilter.scan(pageRequest, filter);
        return this.asUserPage(pageRequest, users, users.getIsLastPage());
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<CrowdGroup> findGroups(@Nonnull PageRequest pageRequest) {
        return StringUtils.isBlank((String)pageRequest.getFilter()) ? this.findAllGroups(pageRequest) : this.findMatchingGroups(pageRequest);
    }

    private Page<CrowdGroup> findAllGroups(PageRequest pageRequest) {
        int start = pageRequest.getStart();
        int limit = pageRequest.getLimit() + 1;
        Iterable groupNames = this.crowdService.search((Query)new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, start, limit));
        Iterable groups = Iterables.limit((Iterable)groupNames, (int)pageRequest.getLimit());
        return this.asGroupPage(pageRequest, groups, Iterables.size((Iterable)groupNames) <= pageRequest.getLimit());
    }

    private Page<CrowdGroup> findMatchingGroups(PageRequest pageRequest) {
        String filter = pageRequest.getFilter();
        GroupMatchingFilter groupFilter = new GroupMatchingFilter(this.crowdService, filter){

            @Override
            Query<String> getQuery(String filter, int offset, int limit) {
                PropertyRestriction restriction = Restriction.on((Property)GroupTermKeys.NAME).containing((Object)filter);
                return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)restriction, offset, limit);
            }
        };
        Page groups = groupFilter.scan(pageRequest, filter);
        return this.asGroupPage(pageRequest, groups.getValues(), groups.getIsLastPage());
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public boolean userExists(@Nonnull String userName) {
        Iterable matches = this.crowdService.search((Query)new UserQuery(String.class, (SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)userName), 0, 1));
        return matches.iterator().hasNext();
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public boolean groupExists(@Nonnull String groupName) {
        Iterable matches = this.crowdService.search((Query)new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)groupName), 0, 1));
        return matches.iterator().hasNext();
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateGroups() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_GROUP);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canDeleteGroups() {
        return this.isAllowedInAnyDirectory(OperationType.DELETE_GROUP);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public CrowdGroup createGroup(@Nonnull String groupName) throws IntegrityException, CrowdRuntimeException {
        try {
            this.crowdService.addGroup((Group)new ImmutableGroup(groupName));
            return new CrowdGroup(groupName, this.canDeleteGroups());
        }
        catch (InvalidGroupException e) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.group.alreadyexists", "A group {0} already exists.", new Object[]{groupName}));
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public CrowdUser deleteUser(@Nonnull String userName) throws IntegrityException, ForbiddenException, NoSuchEntityException, CrowdRuntimeException {
        this.permissionAdminService.canDeleteUser(userName);
        try {
            User user = this.validateUserExists(userName);
            this.crowdService.removeUser(user);
            this.permissionAdminService.revokeAllUserPermissions(userName);
            this.tokenRepository.removeUserTokens(userName);
            return new CrowdUser(user, null, null);
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public CrowdGroup deleteGroup(@Nonnull String groupName) throws IntegrityException, ForbiddenException, NoSuchEntityException, OperationNotPermittedException, CrowdRuntimeException {
        this.permissionAdminService.canDeleteGroup(groupName);
        try {
            Group group = this.validateGroupExists(groupName);
            this.crowdService.removeGroup(group);
            this.permissionAdminService.revokeAllGroupPermissions(groupName);
            return new CrowdGroup(group, true);
        }
        catch (com.atlassian.crowd.exception.OperationNotPermittedException e) {
            throw new OperationNotPermittedException(this.i18nService.getKeyedText("stash.service.delete.group.notpermitted", "The group {0} could not be deleted as it belongs to a read-only directory.", new Object[]{groupName}), (Throwable)e);
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    private Page<CrowdUser> asUserPage(PageRequest pageRequest, Page<User> users, boolean isLastPage) {
        return this.asUserPage(pageRequest, users.getValues(), isLastPage);
    }

    private Page<CrowdUser> asUserPage(PageRequest pageRequest, Iterable<User> users, boolean isLastPage) {
        final DirectoryCache cache = new DirectoryCache(this.directoryService);
        Iterable crowdUsers = Iterables.transform(users, (Function)new Function<User, CrowdUser>(){

            public CrowdUser apply(User user) {
                String directoryName = cache.getDirectoryName(user);
                boolean isReadOnly = cache.isReadOnly(user);
                return new CrowdUser(user, directoryName, Boolean.valueOf(isReadOnly));
            }
        });
        return new PageImpl(pageRequest, crowdUsers, isLastPage);
    }

    private Page<CrowdGroup> asGroupPage(PageRequest pageRequest, Iterable<String> groupNames, boolean isLastPage) {
        final boolean deletable = this.canDeleteGroups();
        Iterable groups = Iterables.transform(groupNames, (Function)new Function<String, CrowdGroup>(){

            public CrowdGroup apply(String groupName) {
                return new CrowdGroup(groupName, deletable);
            }
        });
        return new PageImpl(pageRequest, groups, isLastPage);
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<CrowdUser> findUsersInGroup(@Nonnull PageRequest pageRequest, @Nonnull String group) {
        UserMatchingFilter<CrowdUser> filter = new UserMatchingFilter<CrowdUser>(this.crowdService, USER_TRANSFORM, pageRequest.getFilter()){

            @Override
            Query<User> getQuery(String group, int offset, int limit) {
                return new UserMembersOfGroupQuery(User.class, true, EntityDescriptor.group(), group, EntityDescriptor.user(), offset, limit);
            }
        };
        return filter.scan(pageRequest, group);
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<CrowdUser> findUsersNotInGroup(final @Nonnull PageRequest pageRequest, final @Nonnull String group) {
        final boolean emptyFilter = StringUtils.isBlank((String)pageRequest.getFilter());
        UserMatchingFilter<CrowdUser> filter = new UserMatchingFilter<CrowdUser>(this.crowdService, USER_TRANSFORM, pageRequest.getFilter()){

            @Override
            boolean isMatch(User candidate) {
                return !CrowdAdminServiceImpl.this.crowdService.isUserMemberOfGroup(candidate.getName(), group) && super.isMatch(candidate);
            }

            @Override
            Query<User> getQuery(String group2, int offset, int limit) {
                NullRestriction restriction = emptyFilter ? NullRestrictionImpl.INSTANCE : Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)pageRequest.getFilter()), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)pageRequest.getFilter()), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)pageRequest.getFilter())});
                return new UserQuery(User.class, (SearchRestriction)restriction, offset, limit);
            }
        };
        return filter.scan(pageRequest, group);
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN') or isCurrentUser(#user)")
    public Page<String> findGroupsForUser(@Nonnull PageRequest pageRequest, final @Nonnull String user) {
        GroupMatchingFilter filter = new GroupMatchingFilter(this.crowdService, pageRequest.getFilter()){

            @Override
            Query<String> getQuery(String group, int offset, int limit) {
                return new GroupMembershipQuery(String.class, false, EntityDescriptor.user(), user, EntityDescriptor.group(), offset, limit);
            }
        };
        return filter.scan(pageRequest, user);
    }

    @PreAuthorize(value="hasAnyPermission('PROJECT_ADMIN')")
    public Page<String> findGroupsWithoutUser(final @Nonnull PageRequest pageRequest, final @Nonnull String user) {
        final boolean emptyFilter = StringUtils.isBlank((String)pageRequest.getFilter());
        GroupMatchingFilter filter = new GroupMatchingFilter(this.crowdService, pageRequest.getFilter()){

            @Override
            boolean isMatch(String groupName) {
                return !CrowdAdminServiceImpl.this.crowdService.isUserMemberOfGroup(user, groupName) && super.isMatch(groupName);
            }

            @Override
            Query<String> getQuery(String group, int offset, int limit) {
                NullRestriction restriction = emptyFilter ? NullRestrictionImpl.INSTANCE : Restriction.on((Property)GroupTermKeys.NAME).containing((Object)pageRequest.getFilter());
                return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)restriction, offset, limit);
            }
        };
        return filter.scan(pageRequest, user);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void addUserToGroup(@Nonnull String groupName, @Nonnull String userName) throws ForbiddenException, NoSuchEntityException, LicenseLimitException, CrowdRuntimeException, OperationNotPermittedException {
        this.permissionAdminService.canAddUserToGroup(groupName);
        try {
            Group group = this.validateGroupExists(groupName);
            User user = this.validateUserExists(userName);
            this.licenseService.validateCanAddUserToGroup(userName, groupName);
            this.crowdService.addUserToGroup(user, group);
        }
        catch (com.atlassian.crowd.exception.OperationNotPermittedException ex) {
            LOG.warn(Throwables.getRootCause((Throwable)ex).getLocalizedMessage(), (Throwable)ex);
            throw new OperationNotPermittedException(this.i18nService.getKeyedText("stash.service.remoteUserFromGroup.notpermitted", "The user {0} could not be added to the group {1}. Verify if they are not from the same read-only directory or consult the logs for more information on the error.", new Object[]{userName, groupName}));
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void removeUserFromGroup(@Nonnull String groupName, @Nonnull String userName) throws IntegrityException, ForbiddenException, NoSuchEntityException, CrowdRuntimeException, OperationNotPermittedException {
        boolean primaryUserWasRemovedFromGroup;
        this.permissionAdminService.canRemoveUserFromGroup(userName, groupName);
        try {
            Group group = this.validateGroupExists(groupName);
            User user = this.validateUserExists(userName);
            primaryUserWasRemovedFromGroup = this.crowdService.removeUserFromGroup(user, group);
        }
        catch (GroupNotFoundException e) {
            primaryUserWasRemovedFromGroup = false;
            LOG.debug("Failed to remove user %1$s from group %2$s.", (Throwable)e);
        }
        catch (com.atlassian.crowd.exception.OperationNotPermittedException ex) {
            LOG.warn(Throwables.getRootCause((Throwable)ex).getLocalizedMessage(), (Throwable)ex);
            throw new OperationNotPermittedException(this.i18nService.getKeyedText("stash.service.remoteUserFromGroup.notpermitted", "The user {0} could not be removed from the group {1}. Verify if they are not from the same read-only directory or consult the logs for more information on the error.", new Object[]{userName, groupName}));
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
        if (!primaryUserWasRemovedFromGroup) {
            CrowdUser primaryUser = this.findUserWithDirectoryInfo(userName);
            if (primaryUser == null) {
                throw new NoSuchEntityException(this.i18nService.getKeyedText("stash.service.remoteUserFromGroup.noSuchUser", "The user {0} does not exist.", new Object[]{userName}));
            }
            LOG.info(String.format("Failed to remove user %1$s from group %2$s. Group %2$s may not exist in the same directory as the primary user with name %1$s. The 'primary' user is the first user with that name resolved from the ordered list of User Directories.", userName, groupName));
            throw new NoSuchEntityException(this.i18nService.getKeyedText("stash.service.remoteUserFromGroup.notFromGroup", "The user {0} from directory {1} does not belong to the group {2} in that directory, so can not be removed. This user may be shadowed by a user with the same name in another directory.", new Object[]{userName, primaryUser.getDirectoryName(), groupName}));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public boolean canCreateUsers() {
        return this.isAllowedInAnyDirectory(OperationType.CREATE_USER);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void createUser(@Nonnull String userName, @Nonnull String password, @Nonnull String fullName, @Nonnull String email) throws IntegrityException, LicenseLimitException, CrowdRuntimeException {
        this.createUser(userName, password, fullName, email, true);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void createUser(@Nonnull String userName, @Nonnull String password, @Nonnull String fullName, @Nonnull String email, boolean addToDefaultGroup) throws IntegrityException, LicenseLimitException, CrowdRuntimeException {
        try {
            User user = ImmutableUser.newUser().name(userName).displayName(fullName).emailAddress(email).toUser();
            this.createUser(user, password, addToDefaultGroup);
        }
        catch (InvalidUserException e) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.user.alreadyExists", "A user with this name already exists.", new Object[0]));
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void createUserWithGeneratedPassword(@Nonnull String userName, @Nonnull String fullName, @Nonnull String email) throws IntegrityException, NoMailHostConfigurationException, LicenseLimitException, CrowdRuntimeException, SendingEmailException {
        this.emailNotifier.validateCanSendEmails();
        try {
            User user = ImmutableUser.newUser().name(userName).displayName(fullName).emailAddress(email).toUser();
            String password = this.tokenGenerator.generateToken();
            String token = this.tokenGenerator.generateToken();
            this.createUser(user, password, true);
            this.passwordResetHelper.addResetPasswordToken(user, token);
            this.emailNotifier.sendCreatedUser(user, token);
        }
        catch (InvalidUserException e) {
            throw new IntegrityException(this.i18nService.getKeyedText("stash.service.user.alreadyExists", "A user with this name already exists.", new Object[0]));
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    private void createUser(User user, String password, boolean addToDefaultGroup) throws InvalidUserException, InvalidCredentialException, com.atlassian.crowd.exception.OperationNotPermittedException {
        this.crowdService.addUser(user, password);
        if (addToDefaultGroup) {
            this.addToGroupIfExisting(user, "stash-users");
        }
    }

    private void addToGroupIfExisting(User user, String groupName) throws com.atlassian.crowd.exception.OperationNotPermittedException {
        Group group = this.crowdService.getGroup(groupName);
        if (group != null) {
            this.licenseService.validateCanAddUserToGroup(user.getName(), group.getName());
            this.crowdService.addUserToGroup(user, group);
        }
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void preparePasswordReset(@Nonnull String name) throws NoSuchEntityException, NoMailHostConfigurationException, SendingEmailException, CrowdRuntimeException {
        try {
            User user = this.validateUserExists(name);
            String token = this.tokenGenerator.generateToken();
            this.passwordResetHelper.addResetPasswordToken(user, token);
            this.emailNotifier.sendPasswordReset(user, token);
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public User findByPasswordResetRequest(@Nonnull String token) {
        return this.passwordResetHelper.findUserByResetToken(token);
    }

    @Transactional
    @Unsecured(value="Password reset runs in a non-authenticated context and requires no permissions")
    public void resetPassword(@Nonnull String token, @Nonnull String name, @Nonnull String password) throws InvalidTokenException, NoSuchEntityException, CrowdRuntimeException {
        UserWithAttributes user = this.crowdService.getUserWithAttributes(name);
        if (user == null) {
            throw new NoSuchEntityException(this.i18nService.getKeyedText("stash.service.user.noSuchUser", "No user named '{0}' found", new Object[]{name}));
        }
        boolean match = token.equals(this.passwordResetHelper.getPasswordToken(user));
        if (!match) {
            throw new InvalidTokenException(this.i18nService.getKeyedText("stash.service.invalidtoken", "Invalid token", new Object[0]), token);
        }
        try {
            this.passwordResetHelper.resetPassword((User)user, password);
        }
        catch (CrowdException e) {
            throw new CrowdRuntimeException((Throwable)e);
        }
    }

    private boolean isAllowedInAnyDirectory(OperationType type) {
        List directories = this.directoryService.findAllDirectories();
        for (Directory directory : directories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(type)) continue;
            return true;
        }
        return false;
    }

    private User validateUserExists(String name) {
        User user = this.crowdService.getUser(name);
        if (user == null) {
            throw new NoSuchEntityException(this.i18nService.getKeyedText("stash.service.users.noSuchUser", "No user named ''{0}'' was found", new Object[]{name}));
        }
        return user;
    }

    private Group validateGroupExists(String name) {
        Group group = this.crowdService.getGroup(name);
        if (group == null) {
            throw new NoSuchEntityException(this.i18nService.getKeyedText("stash.service.groups.noSuchGroup", "No group named ''{0}'' was found", new Object[]{name}));
        }
        return group;
    }

    private static final class AllowedDirectoryOperationsImpl
    implements AllowedDirectoryOperations {
        private final boolean mutateAttributes;
        private final boolean mutateGroups;

        private AllowedDirectoryOperationsImpl(boolean mutateAttributes, boolean mutateGroups) {
            this.mutateAttributes = mutateAttributes;
            this.mutateGroups = mutateGroups;
        }

        public boolean canMutateUsersGroups() {
            return this.mutateGroups;
        }

        public boolean canMutateUsersDetails() {
            return this.mutateAttributes;
        }
    }
}

