/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.git.event;

import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class GitPullRequestRefsChangedEvent
extends StashEvent {
    private final RefChange fromRefChange;
    private final RefChange mergeRefChange;
    private final PullRequest pullRequest;

    public GitPullRequestRefsChangedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable RefChange fromRefChange, @Nullable RefChange mergeRefChange) {
        super(source);
        this.fromRefChange = fromRefChange;
        this.mergeRefChange = mergeRefChange;
        this.pullRequest = (PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
    }

    @Nullable
    public RefChange getFromRefChange() {
        return this.fromRefChange;
    }

    @Nullable
    public RefChange getMergeRefChange() {
        return this.mergeRefChange;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public Repository getRepository() {
        return this.pullRequest.getToRef().getRepository();
    }

    public boolean hasFromRefChanged() {
        return this.fromRefChange != null;
    }

    public boolean hasMergeRefChanged() {
        return this.mergeRefChange != null;
    }
}

