/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.core.util.PropertyUtils;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=PackageScannerConfiguration.class)
public class StashPackageScannerConfiguration
extends DefaultPackageScannerConfiguration {
    private static final String EXPORTED_VERSIONS = "library-export-versions.properties";

    @Autowired
    public StashPackageScannerConfiguration(ServletContext servletContext) {
        super(StashPackageScannerConfiguration.determineVersion());
        this.setServletContext(servletContext);
        ArrayList<String> packageIncludes = new ArrayList<String>(this.getPackageIncludes());
        packageIncludes.add("com.google.gson.*");
        packageIncludes.add("ch.qos.logback*");
        packageIncludes.add("org.hibernate.validator*");
        this.setPackageIncludes(packageIncludes);
        ArrayList<String> packageExcludes = new ArrayList<String>(this.getPackageExcludes());
        packageExcludes.add("com.atlassian.stash.internal");
        this.setPackageExcludes(packageExcludes);
        Properties exports = PropertyUtils.getProperties((String)EXPORTED_VERSIONS, ((Object)((Object)this)).getClass());
        this.setPackageVersions((Map)Maps.fromProperties((Properties)exports));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String determineVersion() {
        InputStream in;
        block4: {
            String string;
            in = null;
            Properties props = new Properties();
            try {
                in = StashPackageScannerConfiguration.class.getClassLoader().getResourceAsStream("META-INF/maven/com.atlassian.plugins/atlassian-plugins-core/pom.properties");
                if (in == null) break block4;
                props.load(in);
                string = props.getProperty("version");
            }
            catch (IOException e) {
                String string2;
                try {
                    e.printStackTrace();
                    string2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return string2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return string;
        }
        IOUtils.closeQuietly((InputStream)in);
        return null;
    }
}

