/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.stash.internal.plugin.OsgiServiceProxyFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OsgiServiceProxyFactoryImpl
implements OsgiServiceProxyFactory {
    private final long defaultTimeout;
    private final Cache<Class<?>, ServiceTracker> serviceTrackers;

    @Autowired
    public OsgiServiceProxyFactoryImpl(final OsgiContainerManager osgiContainerManager, @Value(value="${osgi.service.invocation.timeout}") long defaultTimeout) {
        this(new ServiceTrackerFactory(){

            @Override
            public ServiceTracker create(String name) {
                return osgiContainerManager.getServiceTracker(name);
            }
        }, defaultTimeout);
    }

    public OsgiServiceProxyFactoryImpl(final ServiceTrackerFactory serviceTrackerFactory, long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
        this.serviceTrackers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, ServiceTracker>(){

            public ServiceTracker load(Class key) {
                return serviceTrackerFactory.create(key.getName());
            }
        });
    }

    @Override
    public <T> T createProxy(Class<T> apiClass, long timeoutInMillis) {
        return (T)Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)new DynamicServiceInvocationHandler(this.serviceTrackers, apiClass, timeoutInMillis));
    }

    @Override
    public <T> T createProxy(Class<T> apiClass) {
        return this.createProxy(apiClass, this.defaultTimeout);
    }

    static class DynamicServiceInvocationHandler
    implements InvocationHandler {
        private final Cache<Class<?>, ServiceTracker> serviceTrackers;
        private final Class<?> clazz;
        private final long timeoutInMillis;

        DynamicServiceInvocationHandler(Cache<Class<?>, ServiceTracker> serviceTrackers, Class<?> clazz, long timeoutInMillis) {
            this.serviceTrackers = serviceTrackers;
            this.clazz = clazz;
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (Object.class == method.getDeclaringClass()) {
                try {
                    return method.invoke((Object)this, objects);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object service = ((ServiceTracker)this.serviceTrackers.get(this.clazz)).waitForService(this.timeoutInMillis);
                if (service == null) {
                    throw new ServiceTimeoutExceeded("Timeout exceeded waiting for service - " + this.clazz.getName());
                }
                Thread.currentThread().setContextClassLoader(service.getClass().getClassLoader());
                Object object = method.invoke(service, objects);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        public String toString() {
            return "OSGi Service:" + this.clazz.getName();
        }
    }

    public static class ServiceTimeoutExceeded
    extends RuntimeException {
        private static final long serialVersionUID = -5140347192225812816L;

        public ServiceTimeoutExceeded(String message) {
            super(message);
        }
    }

    public static interface ServiceTrackerFactory {
        public ServiceTracker create(String var1);
    }
}

