/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.help;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.help.HelpPathService;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=HelpPathService.class)
public class HelpPathServiceImpl
implements HelpPathService {
    private final Properties helpProperties;

    @Autowired
    public HelpPathServiceImpl(@Value(value="#{helpPathProperties}") Properties properties) {
        this.helpProperties = properties;
    }

    public String getHelpPrefix() {
        return this.helpProperties.getProperty("stash.help.prefix");
    }

    public String getHelpPageUrl(String topicKey) {
        String helpPrefix = this.getHelpPrefix();
        String helpPageKey = this.getHelpPageKey(topicKey);
        if (helpPageKey != null && helpPrefix != null) {
            return String.format("%s/%s", helpPrefix, helpPageKey);
        }
        return null;
    }

    public String getHelpPageKey(String topicKey) {
        return topicKey == null ? null : this.helpProperties.getProperty(topicKey);
    }

    public String getHelpPageTitle(String topicKey) {
        return topicKey == null ? null : this.helpProperties.getProperty(topicKey + ".title");
    }

    public String getHelpPageAlt(String topicKey) {
        return topicKey == null ? null : this.helpProperties.getProperty(topicKey + ".alt");
    }
}

