/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.event;

import com.atlassian.event.config.EventThreadPoolConfiguration;
import com.atlassian.event.internal.DirectEventExecutorFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponsibleEventExecutorFactory
extends DirectEventExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(ResponsibleEventExecutorFactory.class);
    private Executor executor;

    public ResponsibleEventExecutorFactory(EventThreadPoolConfiguration configuration) {
        super(configuration);
    }

    public synchronized Executor getExecutor() {
        if (this.executor == null) {
            this.executor = super.getExecutor();
        }
        return this.executor;
    }

    public void shutdown() {
        if (this.executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)this.executor;
            executorService.shutdown();
            try {
                if (executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.debug("Event dispatcher executor service has shutdown gracefully");
                } else {
                    log.warn("Event dispatcher executor service did not shutdown within the timeout; forcing shutdown");
                    executorService.shutdownNow();
                    if (executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        log.debug("Event dispatcher executor service has been forced to shutdown");
                    } else {
                        log.warn("Event dispatcher executor service did not shutdown; it will be abandoned");
                    }
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for the event dispatcher executor service to shutdown; some worker threads may still be running");
            }
        }
    }
}

