/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.applink.spi;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.applinks.api.application.stash.StashProjectEntityType;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.DefaultEntityReference;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.util.Operation;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(interfaces={InternalHostApplication.class, HostApplication.class})
public class StashHostApplication
extends AbstractInternalHostApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(StashHostApplication.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final TypeAccessor typeAccessor;
    private final ProjectService projectService;
    private final SecurityService securityService;
    private final PermissionService permissionService;
    private ApplicationId applicationId;

    @Autowired
    public StashHostApplication(PluginAccessor pluginAccessor, TypeAccessor typeAccessor, ApplicationPropertiesService applicationPropertiesService, ProjectService projectService, PermissionService permissionService, SecurityService securityService) {
        super(pluginAccessor);
        this.typeAccessor = typeAccessor;
        this.applicationPropertiesService = applicationPropertiesService;
        this.projectService = projectService;
        this.permissionService = permissionService;
        this.securityService = securityService;
    }

    public URI getDocumentationBaseUrl() {
        return URI.create("http://confluence.atlassian.com/display/APPLINKS");
    }

    public String getName() {
        return this.applicationPropertiesService.getDisplayName();
    }

    public ApplicationType getType() {
        return this.typeAccessor.getApplicationType(StashApplicationType.class);
    }

    public Iterable<EntityReference> getLocalEntities() {
        return Iterables.transform((Iterable)this.projectService.findAll((PageRequest)new PageRequestImpl(0, Integer.MAX_VALUE)).getValues(), (Function)new Function<Project, EntityReference>(){

            public EntityReference apply(Project project) {
                return StashHostApplication.this.createProjectEntityReference(project);
            }
        });
    }

    public boolean doesEntityExist(String key, Class<? extends EntityType> type) {
        try {
            return this.findEntity(key, type) != null;
        }
        catch (AuthorisationException e) {
            return false;
        }
    }

    public boolean doesEntityExistNoPermissionCheck(final String key, final Class<? extends EntityType> type) {
        return (Boolean)this.securityService.doWithPermission("Promoting privilege for UAL", Permission.PROJECT_READ, (Operation)new Operation<Boolean, RuntimeException>(){

            public Boolean perform() throws RuntimeException {
                return StashHostApplication.this.doesEntityExist(key, type);
            }
        });
    }

    private Project findProject(String entityReferenceKey) {
        return this.projectService.findByKey(entityReferenceKey);
    }

    private EntityReference findEntity(String key, Class<? extends EntityType> type) {
        if (StashProjectEntityType.class.isAssignableFrom(type)) {
            Project project = this.findProject(key);
            return project != null ? this.createProjectEntityReference(project) : null;
        }
        return null;
    }

    public EntityReference toEntityReference(Object domainObject) {
        if (domainObject instanceof Project) {
            Project project = (Project)domainObject;
            return this.createProjectEntityReference(project);
        }
        return null;
    }

    public EntityReference toEntityReference(String key, Class<? extends EntityType> type) {
        return this.findEntity(key, type);
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        try {
            if (entityReference.getType() instanceof StashProjectEntityType) {
                Project project = this.findProject(entityReference.getKey());
                return project != null && this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN);
            }
            return false;
        }
        catch (AuthorisationException e) {
            return false;
        }
    }

    public boolean hasPublicSignup() {
        return this.applicationPropertiesService.isAllowPublicSignUp();
    }

    public ApplicationId getId() {
        if (this.applicationId == null) {
            byte[] sidBytes = this.applicationPropertiesService.getServerId().getBytes();
            this.applicationId = new ApplicationId(UUID.nameUUIDFromBytes(sidBytes).toString());
        }
        return this.applicationId;
    }

    public URI getBaseUrl() {
        return this.applicationPropertiesService.getBaseUrl();
    }

    private EntityReference createProjectEntityReference(Project project) {
        return new DefaultEntityReference(project.getKey(), project.getName(), (EntityType)Preconditions.checkNotNull((Object)this.typeAccessor.getEntityType(StashProjectEntityType.class), (Object)(StashProjectEntityType.class.getSimpleName() + " not installed!")));
    }
}

