/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.ao;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.AvailableToPlugins;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins(value=DataSourceProvider.class)
public class ApplicationDataSourceProvider
implements DataSourceProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(ApplicationDataSourceProvider.class);
    private static final Map<String, DatabaseType> jdbcTypeMap = new HashMap<String, DatabaseType>();
    private static Pattern jdbcUrlPattern;
    private final DataSource dataSource;
    private final String jdbcURL;

    @Autowired
    public ApplicationDataSourceProvider(DataSource dataSource, @Value(value="${jdbc.url}") String jdbcURL) {
        this.dataSource = dataSource;
        this.jdbcURL = jdbcURL;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatabaseType getDatabaseType() {
        if (this.jdbcURL != null) {
            for (Map.Entry<String, DatabaseType> entry : jdbcTypeMap.entrySet()) {
                if (!this.jdbcURL.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        LOG.warn("Could not determine database type for " + this.jdbcURL);
        return DatabaseType.UNKNOWN;
    }

    public String getSchema() {
        return null;
    }

    static {
        jdbcTypeMap.put("jdbc:hsqldb:", DatabaseType.HSQL);
        jdbcTypeMap.put("jdbc:mysql:", DatabaseType.MYSQL);
        jdbcTypeMap.put("jdbc:oracle:", DatabaseType.ORACLE);
        jdbcTypeMap.put("jdbc:postgresql:", DatabaseType.POSTGRESQL);
        jdbcTypeMap.put("jdbc:jtds:sqlserver:", DatabaseType.MS_SQL);
        jdbcTypeMap.put("jdbc:sqlserver:", DatabaseType.MS_SQL);
    }
}

