/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.stash.internal.home.HomeDirectoryResolver;
import com.atlassian.stash.repository.Version;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSettings {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationSettings.class);
    public static final String LOG_PATH = "log";
    protected static final String BUILD_VERSION = "build.version";
    protected static final String BUILD_TIMESTAMP = "build.timestamp";
    protected static final String BUILD_TIMESTAMP_FORMAT = "build.timestamp.format";
    protected static final String COMMIT_HASH = "commit.hash";
    protected static final String COMMIT_TIMESTAMP = "commit.timestamp";
    private final File homeDir;
    private final File cacheDir;
    private final File osgiCacheDir;
    private final File dataDir;
    private final File reposDir;
    private final File tempDir;
    private final File logDir;
    private final File configDir;
    private final File pluginsDir;
    private final File installedPluginsDir;
    private final File bundledPluginsDir;
    private final File backupDir;
    private final String buildNumber;
    private final String buildVersion;
    private final Date buildTimestamp;
    private final String commitHash;
    private final Date commitTimestamp;
    private final Set<String> requiredPluginKeys;

    public ApplicationSettings(Properties requiredPluginProperties) {
        this(requiredPluginProperties, new HomeDirectoryResolver().resolve());
    }

    protected ApplicationSettings(Properties requiredPluginProperties, File homeDir) {
        this.homeDir = homeDir;
        this.createDirectoryIfNonexistent(homeDir);
        LOG.debug("Running with Home Directory = " + homeDir);
        this.cacheDir = new File(this.homeDir, "caches");
        this.configDir = new File(this.homeDir, "config");
        this.dataDir = new File(this.homeDir, "data");
        this.reposDir = new File(this.dataDir, "repositories");
        this.backupDir = new File(this.homeDir, "export");
        this.logDir = new File(this.homeDir, LOG_PATH);
        this.pluginsDir = new File(this.homeDir, "plugins");
        this.installedPluginsDir = new File(this.pluginsDir, "installed-plugins");
        this.osgiCacheDir = new File(this.pluginsDir, ".osgi-cache");
        this.bundledPluginsDir = new File(this.pluginsDir, ".bundled-plugins");
        this.tempDir = new File(this.homeDir, "tmp");
        this.createDirectoryIfNonexistent(this.configDir);
        this.createDirectoryIfNonexistent(this.dataDir);
        this.createDirectoryIfNonexistent(this.reposDir);
        this.createDirectoryIfNonexistent(this.tempDir);
        this.createDirectoryIfNonexistent(this.pluginsDir);
        Properties buildProperties = this.loadProperties("build.properties");
        this.buildVersion = buildProperties.getProperty(BUILD_VERSION);
        this.buildTimestamp = this.parseBuildTimestamp(buildProperties, BUILD_TIMESTAMP_FORMAT);
        this.commitHash = buildProperties.getProperty(COMMIT_HASH);
        this.commitTimestamp = this.parseCommitTimestamp(buildProperties, COMMIT_TIMESTAMP);
        ImmutableSet.Builder requiredPluginsBuilder = ImmutableSet.builder();
        if (requiredPluginProperties != null) {
            Enumeration<?> propertyNames = requiredPluginProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = propertyNames.nextElement().toString();
                requiredPluginsBuilder.add((Object)key);
            }
        }
        this.requiredPluginKeys = requiredPluginsBuilder.build();
        this.buildNumber = this.calculateBuildNumber(this.buildVersion);
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public File getOsgiCacheDir() {
        return this.osgiCacheDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getRepositoriesDir() {
        return this.reposDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getPluginsDir() {
        return this.pluginsDir;
    }

    public File getInstalledPluginsDir() {
        return this.installedPluginsDir;
    }

    public File getBundledPluginsDir() {
        return this.bundledPluginsDir;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public Date getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public Date getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public Set<String> getRequiredPluginKeys() {
        return this.requiredPluginKeys;
    }

    protected Properties loadProperties(String propertyFile) {
        Properties buildProperties = new Properties();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(propertyFile);
            while (resources != null && resources.hasMoreElements()) {
                buildProperties.load(resources.nextElement().openStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buildProperties;
    }

    private String calculateBuildNumber(String buildVersion) {
        List version = new Version(buildVersion).getVersion();
        long major = ((Integer)version.get(0)).intValue();
        long minor = ((Integer)version.get(1)).intValue();
        long patch = ((Integer)version.get(2)).intValue();
        long full = (major * 1000L + minor) * 1000L + patch;
        return String.valueOf(full);
    }

    private void createDirectoryIfNonexistent(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalStateException(directory + " already exists and is not a directory");
            }
        } else if (!directory.mkdirs()) {
            throw new IllegalStateException("Could not create " + directory);
        }
    }

    private Date parseBuildTimestamp(Properties buildProperties, String property) {
        try {
            return new SimpleDateFormat(buildProperties.getProperty(property)).parse(buildProperties.getProperty(BUILD_TIMESTAMP));
        }
        catch (ParseException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private Date parseCommitTimestamp(Properties buildProperties, String property) {
        try {
            return new Date(Long.parseLong(buildProperties.getProperty(property)));
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

