/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.internal.repository.InternalRepository;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="cs_repo_membership")
@IdClass(value=PK.class)
public class InternalRepositoryMembership {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cs_id")
    private final InternalIndexedChangeset changeset;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="repository_id")
    private final InternalRepository repository;

    protected InternalRepositoryMembership() {
        this.changeset = null;
        this.repository = null;
    }

    public InternalRepositoryMembership(@Nonnull InternalIndexedChangeset changeset, @Nonnull InternalRepository repository) {
        this.changeset = changeset;
        this.repository = repository;
    }

    public InternalIndexedChangeset getChangeset() {
        return this.changeset;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepositoryMembership) {
            InternalRepositoryMembership that = (InternalRepositoryMembership)o;
            return this.changeset.equals(that.changeset) && this.repository.equals(that.repository);
        }
        return false;
    }

    public int hashCode() {
        int result = this.changeset.hashCode();
        result = 31 * result + this.repository.hashCode();
        return result;
    }

    public static class PK
    implements Serializable {
        private final String changeset;
        private final int repository;

        public PK() {
            this(null, 0);
        }

        public PK(String changeset, int repository) {
            this.changeset = changeset;
            this.repository = repository;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            if (this.changeset != pk.changeset) {
                return false;
            }
            return this.repository == pk.repository;
        }

        public int hashCode() {
            int result = this.changeset.hashCode();
            result = 31 * result + this.repository;
            return result;
        }
    }
}

