/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.stash.internal.auth.trusted.InternalTrustedApplicationRestriction;
import com.atlassian.stash.util.CustomPreconditions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Table(name="trusted_app")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalTrustedApplication {
    private static final String ID_GEN = "trustedAppIdGenerator";
    static final String TABLE = "trusted_app";
    @TableGenerator(name="trustedAppIdGenerator", table="id_sequence", pkColumnValue="trusted_app", allocationSize=10)
    @Id
    @GeneratedValue(generator="trustedAppIdGenerator", strategy=GenerationType.TABLE)
    private final Integer id;
    @Column(name="application_id", nullable=false, unique=true)
    private final String applicationId;
    @Column(name="public_key", nullable=false)
    @Lob
    private final byte[] publicKey;
    @OneToMany(mappedBy="application", fetch=FetchType.EAGER)
    private final Set<InternalTrustedApplicationRestriction> restrictions = Sets.newHashSet();
    @Column(name="certificate_timeout", nullable=false)
    private final long certificateTimeout;

    protected InternalTrustedApplication() {
        this.id = null;
        this.applicationId = null;
        this.publicKey = null;
        this.certificateTimeout = 1000L;
    }

    private InternalTrustedApplication(Integer id, String applicationId, byte[] publicKey, long certificateTimeout, Iterable<String> ipPatterns, Iterable<String> urlPatterns) {
        this.id = id;
        this.applicationId = applicationId;
        this.publicKey = publicKey;
        this.certificateTimeout = certificateTimeout;
        CustomPreconditions.checkRequiredString((String)applicationId, (int)255);
        if (ipPatterns != null) {
            Iterables.addAll(this.restrictions, (Iterable)Iterables.transform(ipPatterns, this.restrictionFromString(InternalTrustedApplicationRestriction.Type.IP)));
        }
        if (urlPatterns != null) {
            Iterables.addAll(this.restrictions, (Iterable)Iterables.transform(urlPatterns, this.restrictionFromString(InternalTrustedApplicationRestriction.Type.URL)));
        }
    }

    public Integer getId() {
        return this.id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public Iterable<String> getIPPatterns() {
        return Iterables.transform((Iterable)Sets.filter(this.restrictions, this.byType(InternalTrustedApplicationRestriction.Type.IP)), this.restrictionToString());
    }

    public Iterable<String> getUrlPatterns() {
        return Iterables.transform((Iterable)Sets.filter(this.restrictions, this.byType(InternalTrustedApplicationRestriction.Type.URL)), this.restrictionToString());
    }

    public long getCertificateTimeout() {
        return this.certificateTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalTrustedApplication)) {
            return false;
        }
        InternalTrustedApplication that = (InternalTrustedApplication)o;
        return this.applicationId == null ? that.applicationId == null : this.applicationId.equals(that.applicationId);
    }

    public int hashCode() {
        return this.applicationId != null ? this.applicationId.hashCode() : 0;
    }

    public Builder copy() {
        return new Builder(this);
    }

    private Predicate<? super InternalTrustedApplicationRestriction> byType(final InternalTrustedApplicationRestriction.Type type) {
        return new Predicate<InternalTrustedApplicationRestriction>(){

            public boolean apply(InternalTrustedApplicationRestriction input) {
                return input.getType() == type;
            }
        };
    }

    private Function<InternalTrustedApplicationRestriction, String> restrictionToString() {
        return new Function<InternalTrustedApplicationRestriction, String>(){

            public String apply(InternalTrustedApplicationRestriction input) {
                return input.getValue();
            }
        };
    }

    private Function<String, InternalTrustedApplicationRestriction> restrictionFromString(final InternalTrustedApplicationRestriction.Type type) {
        return new Function<String, InternalTrustedApplicationRestriction>(){

            public InternalTrustedApplicationRestriction apply(String input) {
                return new InternalTrustedApplicationRestriction(InternalTrustedApplication.this, type, input);
            }
        };
    }

    public static class Builder {
        private Integer id;
        private String applicationId;
        private byte[] publicKey;
        private Set<String> ipPatterns = Sets.newHashSet();
        private Set<String> urlPatterns = Sets.newHashSet();
        private long certificateTimeout;

        public Builder() {
        }

        public Builder(InternalTrustedApplication trustedApp) {
            this.id = trustedApp.getId();
            this.applicationId = trustedApp.getApplicationId();
            this.publicKey = trustedApp.getPublicKey();
            this.certificateTimeout = trustedApp.getCertificateTimeout();
            Iterables.addAll(this.ipPatterns, trustedApp.getIPPatterns());
            Iterables.addAll(this.urlPatterns, trustedApp.getUrlPatterns());
        }

        public Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder certificateTimeout(long certificateTimeout) {
            this.certificateTimeout = certificateTimeout;
            return this;
        }

        public Builder ipPatterns(Iterable<String> ipPatterns) {
            this.ipPatterns.clear();
            Iterables.addAll(this.ipPatterns, ipPatterns);
            return this;
        }

        public Builder urlPatterns(Iterable<String> urlPatterns) {
            this.urlPatterns.clear();
            Iterables.addAll(this.urlPatterns, urlPatterns);
            return this;
        }

        public InternalTrustedApplication build() {
            return new InternalTrustedApplication(this.id, this.applicationId, this.publicKey, this.certificateTimeout, this.ipPatterns, this.urlPatterns);
        }
    }
}

