/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.stash.internal.user.InternalStashUser;
import com.atlassian.stash.internal.user.StashUserDao;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class SynchronisingCrowdUserDaoImpl
extends UserDAOHibernate {
    private final StashUserDao stashUserDao;

    @Autowired
    public SynchronisingCrowdUserDaoImpl(StashUserDao stashUserDao) {
        this.stashUserDao = stashUserDao;
    }

    public InternalUser add(User user, PasswordCredential passwordCredential) throws UserAlreadyExistsException, IllegalArgumentException, DirectoryNotFoundException {
        this.createIfNeeded(user);
        return super.add(user, passwordCredential);
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> userTemplateWithCredentialAndAttributes) {
        BatchResult result = super.addAll(userTemplateWithCredentialAndAttributes);
        for (User createdUser : result.getSuccessfulEntities()) {
            this.createIfNeeded(createdUser);
        }
        return result;
    }

    void createIfNeeded(User crowdUser) {
        if (this.stashUserDao.findByName(crowdUser.getName()) == null) {
            InternalStashUser stashUser = new InternalStashUser(crowdUser.getName());
            this.stashUserDao.create((Object)stashUser);
        }
    }
}

