/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.internal.AbstractDaoImpl;
import com.atlassian.stash.internal.content.ChangesetDao;
import com.atlassian.stash.internal.idx.InternalChangesetAttribute;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ChangesetDaoImpl
extends AbstractDaoImpl<String, InternalIndexedChangeset>
implements ChangesetDao {
    @Autowired
    public ChangesetDaoImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Order getImplicitOrder() {
        return Order.desc((String)"authorTimestamp");
    }

    private InternalRepositoryMembership getMembership(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        Preconditions.checkNotNull((Object)changesetId, (Object)"changesetId cannot be null");
        Preconditions.checkNotNull((Object)repository, (Object)"repository cannot be null");
        return (InternalRepositoryMembership)this.session().get(InternalRepositoryMembership.class, (Serializable)new InternalRepositoryMembership.PK(changesetId, repository.getId().intValue()));
    }

    public boolean isMemberOf(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        return this.getMembership(changesetId, repository) != null;
    }

    public boolean addMembership(@Nonnull InternalIndexedChangeset changeset, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(changeset.getId(), repository);
        if (membership == null) {
            this.session().save((Object)new InternalRepositoryMembership(changeset, repository));
        }
        return membership == null;
    }

    public boolean deleteMembership(@Nonnull String changesetId, @Nonnull InternalRepository repository) {
        InternalRepositoryMembership membership = this.getMembership(changesetId, repository);
        if (membership != null) {
            this.session().delete((Object)membership);
            InternalIndexedChangeset changeset = membership.getChangeset();
            Set memberships = changeset.getRepositoryMemberships();
            memberships.remove(membership);
            if (memberships.isEmpty()) {
                this.delete(membership.getChangeset());
            }
        }
        return membership != null;
    }

    public void deleteAllMemberships(@Nonnull InternalRepository repository) {
        Query query = this.session().createQuery("DELETE from InternalRepositoryMembership where repository = ?");
        query.setParameter(0, (Object)repository);
        query.executeUpdate();
    }

    private InternalChangesetAttribute getAttribute(@Nonnull String changesetId, @Nonnull String attName, @Nonnull String attValue) {
        Preconditions.checkNotNull((Object)changesetId, (Object)"changesetId cannot be null");
        Preconditions.checkNotNull((Object)attName, (Object)"attributeName cannot be null");
        Preconditions.checkNotNull((Object)attValue, (Object)"attributeValue cannot be null");
        return (InternalChangesetAttribute)this.session().get(InternalChangesetAttribute.class, (Serializable)new InternalChangesetAttribute.PK(changesetId, attName, attValue));
    }

    public boolean addAttribute(@Nonnull InternalIndexedChangeset changeset, @Nonnull String attribute, @Nonnull String value) {
        InternalChangesetAttribute att = this.getAttribute(changeset.getId(), attribute, value);
        if (att == null) {
            this.session().save((Object)new InternalChangesetAttribute(changeset, attribute, value));
        }
        return att == null;
    }

    public boolean removeAttribute(@Nonnull String changesetId, @Nonnull String attribute, @Nonnull String value) {
        InternalChangesetAttribute att = this.getAttribute(changesetId, attribute, value);
        if (att != null) {
            this.session().delete((Object)att);
        }
        return att != null;
    }

    public List<InternalIndexedChangeset> findByAttribute(@Nonnull String attributeName, @Nonnull String attributeValue, boolean caseSensitive) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName cannot be null");
        Preconditions.checkNotNull((Object)attributeValue, (Object)"attributeValue cannot be null");
        return this.session().createQuery("SELECT cs FROM InternalIndexedChangeset cs, InternalChangesetAttribute att WHERE att.name = ? AND " + (caseSensitive ? "att.value = ? " : "lower(att.value) = lower(?) ") + "AND att.changeset = cs ORDER BY cs.authorTimestamp DESC").setString(0, attributeName).setString(1, attributeValue).list();
    }

    public AttributeMap getAttributesForChangeset(String changesetId, Collection<String> attributeNames) {
        if (changesetId == null || CollectionUtils.isEmpty(attributeNames)) {
            return AttributeMap.EMPTY;
        }
        List attributes = this.session().createQuery("from InternalChangesetAttribute where changeset.id = :id and name in (:names)").setString("id", changesetId).setParameterList("names", attributeNames).list();
        AttributeMap.Builder attributeMap = new AttributeMap.Builder();
        for (InternalChangesetAttribute attribute : attributes) {
            attributeMap.add(attribute.getName(), new String[]{attribute.getValue()});
        }
        return attributeMap.build();
    }

    public Map<String, AttributeMap> getAttributesForChangesets(Collection<String> changesetIds, Collection<String> attributeNames) {
        if (CollectionUtils.isEmpty(changesetIds) || CollectionUtils.isEmpty(attributeNames)) {
            return Collections.emptyMap();
        }
        List attributes = this.session().createQuery("from InternalChangesetAttribute where changeset.id in (:ids) and name in (:names)").setParameterList("ids", changesetIds).setParameterList("names", attributeNames).list();
        HashMap resultBuilder = Maps.newHashMap();
        for (InternalChangesetAttribute att : attributes) {
            AttributeMap.Builder attributeMap = (AttributeMap.Builder)resultBuilder.get(att.getChangeset());
            if (attributeMap == null) {
                attributeMap = new AttributeMap.Builder();
                resultBuilder.put(att.getChangeset(), attributeMap);
            }
            attributeMap.add(att.getName(), new String[]{att.getValue()});
        }
        HashMap<String, AttributeMap> result = new HashMap<String, AttributeMap>();
        for (Map.Entry entry : resultBuilder.entrySet()) {
            result.put(((InternalIndexedChangeset)entry.getKey()).getId(), ((AttributeMap.Builder)entry.getValue()).build());
        }
        return result;
    }

    public Set<String> getAttributeValues(String changesetId, String attributeName) {
        AttributeMap result = this.getAttributesForChangeset(changesetId, Collections.singleton(attributeName));
        return result.isEmpty() ? Collections.emptySet() : result.get((Object)attributeName);
    }
}

