/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.stash.internal.Dao;
import com.atlassian.stash.util.FilteredPageImpl;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;

public abstract class AbstractDaoImpl<K extends Serializable, E>
implements Dao<K, E> {
    protected final Class<E> entityClass;
    private final SessionFactory sessionFactory;

    public AbstractDaoImpl(SessionFactory sessionFactory) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[1];
        this.sessionFactory = sessionFactory;
    }

    public E create(E entity) {
        this.session().saveOrUpdate(entity);
        return entity;
    }

    public void delete(E entity) {
        this.session().delete(entity);
    }

    @Nonnull
    public Page<E> findAll(PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(this.entityClass);
        return this.pageCriteria(criteria, pageRequest);
    }

    @Nonnull
    public Page<E> findAll(PageRequest pageRequest, Predicate<? super E> predicate) {
        Criteria criteria = this.session().createCriteria(this.entityClass);
        return this.pageCriteria(criteria, pageRequest, predicate);
    }

    public E getById(K id) {
        return (E)this.session().get(this.entityClass, id);
    }

    public E update(E entity) {
        return (E)this.session().merge(entity);
    }

    protected abstract Order getImplicitOrder();

    @Nonnull
    protected <T> Page<T> getPage(PageSource<T> source, PageRequest request, Predicate<? super T> predicate) {
        Page<T> internalPage;
        int internalStart = request.getStart();
        int internalLimit = request.getLimit() * 2;
        int pageLimit = request.getLimit() + 1;
        TreeMap results = new TreeMap();
        block0: do {
            PageRequestImpl internalRequest = new PageRequestImpl(internalStart, internalLimit);
            internalPage = source.getPage((PageRequest)internalRequest);
            for (Map.Entry entry : internalPage.getOrdinalIndexedValues().entrySet()) {
                if (!predicate.apply(entry.getValue())) continue;
                results.put(entry.getKey(), entry.getValue());
                if (results.size() != pageLimit) continue;
                break block0;
            }
            internalStart += internalLimit;
        } while (results.size() < pageLimit && !internalPage.getIsLastPage());
        int size = results.size();
        boolean lastPage = size < pageLimit;
        int pageSize = lastPage ? size : request.getLimit();
        return new FilteredPageImpl(request, pageSize, results, lastPage);
    }

    protected <T> Page<T> pageCriteria(Criteria criteria, PageRequest request, Predicate<? super T> predicate) {
        criteria.addOrder(this.getImplicitOrder());
        return this.getPage(new CriteriaPageSource(criteria), request, predicate);
    }

    protected <T> Page<T> pageCriteria(Criteria criteria, PageRequest pageRequest) {
        criteria.setFirstResult(pageRequest.getStart());
        criteria.setMaxResults(pageRequest.getLimit() + 1);
        criteria.addOrder(this.getImplicitOrder());
        List resultList = criteria.list();
        return PageUtils.createPage((Iterable)resultList, (PageRequest)pageRequest);
    }

    protected <T> Page<T> pageQuery(Query query, PageRequest request, Predicate<? super T> predicate) {
        return this.getPage(new QueryPageSource(query), request, predicate);
    }

    protected <T> Page<T> pageQuery(Query query, PageRequest pageRequest) {
        query.setFirstResult(pageRequest.getStart());
        query.setMaxResults(pageRequest.getLimit() + 1);
        List resultList = query.list();
        return PageUtils.createPage((Iterable)resultList, (PageRequest)pageRequest);
    }

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    protected final class QueryPageSource<T>
    implements PageSource<T> {
        private final Query query;

        public QueryPageSource(Query query) {
            this.query = query;
        }

        @Override
        public Page<T> getPage(PageRequest request) {
            return AbstractDaoImpl.this.pageQuery(this.query, request);
        }
    }

    protected final class CriteriaPageSource<T>
    implements PageSource<T> {
        private final Criteria criteria;

        public CriteriaPageSource(Criteria criteria) {
            this.criteria = criteria;
        }

        @Override
        public Page<T> getPage(PageRequest request) {
            return AbstractDaoImpl.this.pageCriteria(this.criteria, request);
        }
    }

    protected static interface PageSource<T> {
        public Page<T> getPage(PageRequest var1);
    }
}

