define('feature/branch-deletion', [
    'aui',
    'jquery',
    'lodash',
    'stash/api/util/navbuilder',
    'util/ajax',
    'util/events',
    'util/shortcuts',
    'model/page-state',
    'widget/confirm-dialog',
    'exports'
], function (
    AJS,
    $,
    _,
    nav,
    ajax,
    events,
    shortcuts,
    pageState,
    ConfirmDialog,
    exports
) {
    var linkSelector = '.delete-branch';

    function createConfirmationDialog() {
        var dialog = new ConfirmDialog({
            id : 'delete-branch-dialog',
            titleText: AJS.I18n.getText('stash.feature.branch-deletion.dialog.title'),
            titleClass : 'warning-header',
            panelContent : stash.feature.branchDeletion.dialog(),
            submitText : AJS.I18n.getText('stash.web.button.delete'),
            submitToHref : false
        });

        dialog.addConfirmListener(function(promise, $trigger, removeDialog, dialog, $spinner) {
            var branchId = getBranchData($trigger, 'id');
            var branchDisplayId = getBranchData($trigger, 'display-id');
            var latestChangeset = getBranchData($trigger, 'latest-changeset');
            $spinner.show();
            deleteBranchByRest(branchDisplayId, latestChangeset).done(function() {
                events.trigger('stash.page.branches.revisionRefRemoved', null, {
                    id: branchId,
                    displayId: branchDisplayId,
                    latestChangeset: latestChangeset
                });
            }).fail(function (xhr, textStatus, errorThrown, data) {
                addErrorNotifications(branchDisplayId, data && data.errors);
            }).always(removeDialog);
        });

        dialog.attachTo(linkSelector, function(trigger, dialog) {
            var branchName = getBranchData(trigger, 'display-id');
            dialog.getCurrentPanel().body.find('.branch-name').text(branchName);

            //the href is of the form #<ahead number>
            var ahead = parseInt($(trigger).attr('href').substring(1), 10);
            if (ahead > 0) {
                var baseRefDisplayId = getBranchData('#branch-list', 'base-ref-display-id');
                dialog.getCurrentPanel().body.append(stash.feature.branchDeletion.aheadWarning({
                    ahead: ahead,
                    baseRefDisplayId: baseRefDisplayId
                }));
            }


        }, document);
    }

    function deleteBranchByRest(branchName, latestChangeset) {
        return ajax.rest({
            url: getBranchRestUrl(),
            type: 'DELETE',
            data: {
                name : branchName,
                endPoint : latestChangeset
            },
            statusCode : {
                '400' : false,
                '403' : false,
                '409' : false
            }
        });
    }

    function getBranchData(trigger, dataKey) {
        var attr = 'data-' + dataKey;
        return $(trigger).closest('[' + attr + ']').attr(attr);
    }

    function getBranchRestUrl() {
        return nav.rest('branch-utils')
            .project(pageState.getProject().getKey())
            .repo(pageState.getRepository().getSlug())
            .addPathComponents('branches').build();
    }

    function addErrorNotifications(branchName, errors) {
        if (errors && errors.length > 0) {
            var errorBody = "";
            _.forEach(errors, function(error) {
                errorBody += stash.widget.errorContent(error);
            });
            require(['aui/flag'], function(flag) {
                flag({
                    type: 'error',
                    body: errorBody
                });
            });
        }
    }

    exports.onReady = function () {
        createConfirmationDialog();

        shortcuts.bind('branchlist.deleteBranch', function() {
            $('#branch-list tr.focused .delete-branch').click();
        });
    };
});

jQuery(document).ready(function () {
    require('feature/branch-deletion').onReady();
});
