define('page/branch-creation', [
    'jquery',
    'feature/branch-creation/form',
    'feature/jira/jira-issues-dialog',
    'exports'
], function (
    $,
    BranchCreationForm,
    JiraIssuesDialog,
    exports
) {
    var branchCreationForm;
    var jiraIssuesDialog;

    exports.onReady = function(recentRepositories, branchTypes) {
        branchCreationForm = new BranchCreationForm($('.branch-creation-form'), recentRepositories, branchTypes);

        var issueLinkSelector = 'a.jira-issue-key';
        // initialise the JIRA issues dialog only if the link exists
        if ($(issueLinkSelector).length) {
            jiraIssuesDialog = new JiraIssuesDialog({
                id: 'branch-creation-jira-issues-dialog',
                triggerSelector: issueLinkSelector
            });
        }
    };
});
