jQuery(document).ready(function() {
    require([
        'aui',
        'chaperone',
        'util/client-storage',
        'util/events'
    ], function(
        AJS,
        Chaperone,
        clientStorage,
        events
    ) {
        function isComingFromBranchCreation() {
            var createdDate = clientStorage.getFlashItem('stash.branch.created');

            // if they took longer than 30 sec, they probably went somewhere else in between and it'd be weird to show them this.
            return createdDate + (30 * 1000) > new Date().getTime();
        }

        function showActionDiscovery() {
            Chaperone.registerFeature('branch-created-actions-discovery', [{
                id : 'action-discovery',
                selector : '#branch-actions',
                title : AJS.I18n.getText('stash.web.branch.actions.feature.discovery.title'),
                content : stash.widget.paragraph({
                    text: AJS.I18n.getText('stash.web.branch.actions.feature.discovery.content')
                }),
                once: true
            }]);
        }

        events.on('stash.feature.branch-creation.branchCreated', function() {
            clientStorage.setFlashItem('stash.branch.created', new Date().getTime());
        });

        if (isComingFromBranchCreation()) {
            showActionDiscovery();
        }
    });
});