/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.version;

import com.atlassian.stash.internal.branch.model.exception.IllegalVersionStringException;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class BranchVersion
implements Comparable<BranchVersion> {
    private final String original;
    private final List<Component> components;
    private final int firstNumeric;

    private BranchVersion(String original, List<Component> components) {
        this.original = original;
        this.components = components;
        this.firstNumeric = this.findFirstNumeric();
        if (this.firstNumeric == -1) {
            throw new IllegalVersionStringException("'" + original + "' does not contain a version");
        }
    }

    @Nonnull
    public static BranchVersion parse(@Nonnull String versionString, @Nonnull String versionComponentSeparators) {
        Preconditions.checkNotNull((Object)versionComponentSeparators, (Object)"versionComponentSeparators");
        Object[] components = ((String)Preconditions.checkNotNull((Object)versionString, (Object)"versionString")).split(versionComponentSeparators);
        return new BranchVersion(versionString, Chainable.chain((Object[])components).filter(PredicateUtils.notBlank()).transform(Component.FROM_CONTENT).toList());
    }

    @Override
    public int compareTo(@Nonnull BranchVersion that) {
        if (!this.isCompatibleWith(that)) {
            throw new IllegalArgumentException(this + "is not compatible to " + that);
        }
        int max = Math.min(this.components.size(), that.components.size());
        for (int i = this.firstNumeric; i < max; ++i) {
            int result = this.componentAt(i).compareTo(that.componentAt(i));
            if (result == 0) continue;
            return result;
        }
        int bySize = Integer.compare(this.components.size(), that.components.size());
        if (bySize != 0) {
            if (this.findComponentAt(max, that).isNumeric()) {
                return bySize;
            }
            return -bySize;
        }
        return this.original.compareTo(that.original);
    }

    @Nonnull
    public Predicate<BranchVersion> matcher() {
        return new Predicate<BranchVersion>(){

            public boolean apply(BranchVersion value) {
                return BranchVersion.this.isCompatibleWith(value);
            }
        };
    }

    public boolean isCompatibleWith(@Nonnull BranchVersion that) {
        if (this.firstNumeric != that.firstNumeric) {
            return false;
        }
        int componentsToCompare = this.firstNumeric >= 0 ? this.firstNumeric : this.components.size();
        for (int i = 0; i < componentsToCompare; ++i) {
            if (this.componentAt(i).compareTo(that.componentAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BranchVersion that = (BranchVersion)obj;
        return this.original.equals(that.original);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("original", (Object)this.original).add("components", this.components).toString();
    }

    private int findFirstNumeric() {
        for (int i = 0; i < this.components.size(); ++i) {
            if (!this.components.get(i).isNumeric()) continue;
            return i;
        }
        return -1;
    }

    private Component componentAt(int i) {
        return this.components.get(i);
    }

    private Component findComponentAt(int i, BranchVersion that) {
        if (this.components.size() > i) {
            return this.componentAt(i);
        }
        return that.componentAt(i);
    }

    private static class Component
    implements Comparable<Component> {
        static final Function<String, Component> FROM_CONTENT = new Function<String, Component>(){

            public Component apply(String content) {
                return new Component(content);
            }
        };
        private final String content;
        private final Integer numericContent;
        private final boolean isNumeric;

        private Component(@Nonnull String content) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)content), (Object)"Content cannot be blank");
            this.content = content;
            this.numericContent = this.parseNumeric(content);
            this.isNumeric = this.numericContent != null;
        }

        private Integer parseNumeric(String content) {
            try {
                return Integer.valueOf(content);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        boolean isNumeric() {
            return this.isNumeric;
        }

        @Override
        public int compareTo(@Nonnull Component that) {
            if (this.isNumeric && that.isNumeric) {
                return this.numericContent.compareTo(that.numericContent);
            }
            if (this.isNumeric) {
                return 1;
            }
            if (that.isNumeric) {
                return -1;
            }
            return this.content.compareTo(that.content);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Component that = (Component)obj;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public String toString() {
            return this.content;
        }
    }
}

