/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.rest;

import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.internal.branch.model.InternalBranchType;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=InternalBranchType.class)
public class RestBranchType
extends RestMapEntity {
    public static final String ID = "id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String PREFIX = "prefix";
    public static final Function<Object, RestBranchType> REST_TRANSFORM = new Function<Object, RestBranchType>(){

        public RestBranchType apply(Object input) {
            return RestBranchType.valueOf(input);
        }
    };
    public static final RestBranchType BUGFIX_RESPONSE_EXAMPLE = new RestBranchType("BUGFIX", "Bugfix", "bugfix/");
    public static final RestBranchType FEATURE_RESPONSE_EXAMPLE = new RestBranchType("FEATURE", "Feature", "feature/");

    public RestBranchType() {
    }

    public RestBranchType(@Nonnull BranchType type) {
        this(type.getId(), type.getDisplayName(), RestBranchType.getPrefix(type));
    }

    private RestBranchType(@Nonnull String id, @Nullable String name, @Nullable String prefix) {
        this.put(ID, id);
        this.putIfNotNull(DISPLAY_NAME, name);
        this.putIfNotNull(PREFIX, prefix);
    }

    private RestBranchType(@Nonnull String id) {
        this(id, null, null);
    }

    private RestBranchType(Map<String, Object> values) {
        super(values);
    }

    public static RestBranchType valueOf(Object value) {
        if (value instanceof RestBranchType) {
            return (RestBranchType)((Object)value);
        }
        if (value instanceof BranchType) {
            return new RestBranchType((BranchType)value);
        }
        if (value instanceof Map) {
            return new RestBranchType((Map)value);
        }
        return null;
    }

    private static String getPrefix(BranchType branchType2) {
        if (branchType2 instanceof InternalBranchType) {
            return ((InternalBranchType)InternalBranchType.class.cast(branchType2)).getPrefix();
        }
        return null;
    }
}

