/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.branch.model.BranchModel;
import com.atlassian.stash.branch.model.BranchModelService;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.model.rest.RestBranchModel;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.atlassian.stash.rest.util.RestResource;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/branchmodel")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class BranchModelResource
extends RestResource {
    private final BranchModelService branchModelService;

    public BranchModelResource(I18nService i18nService, BranchModelService branchModelService) {
        super(i18nService);
        this.branchModelService = branchModelService;
    }

    @GET
    public Response getBranchModel(@Context Repository repository) {
        BranchModel model = this.branchModelService.getModel(repository);
        if (model == null) {
            return ResponseFactory.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestErrors(this.i18nService.getMessage("stash.branchmodel.rest.error.modelnotfound", new Object[]{repository}))).build();
        }
        return ResponseFactory.ok((Object)((Object)new RestBranchModel(model))).build();
    }
}

