/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.model;

import com.atlassian.stash.branch.model.BranchType;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.model.BranchTypes;
import com.atlassian.stash.internal.branch.model.InternalBranchType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

class InternalBranchTypes {
    static final InternalBranchTypes BUGFIX = InternalBranchTypes.forType(BranchTypes.BUGFIX);
    static final InternalBranchTypes FEATURE = InternalBranchTypes.forType(BranchTypes.FEATURE);
    static final InternalBranchTypes HOTFIX = InternalBranchTypes.forType(BranchTypes.HOTFIX);
    static final InternalBranchTypes RELEASE = InternalBranchTypes.forType(BranchTypes.RELEASE);
    private static final String I18N_PREFIX = "stash.branchmodel.type.";
    private final BranchTypes type;

    private InternalBranchTypes(@Nonnull BranchTypes type) {
        this.type = (BranchTypes)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
    }

    static InternalBranchType asInternalBranchType(@Nonnull BranchType branchType2) {
        Preconditions.checkNotNull((Object)branchType2, (Object)"branchType");
        if (!InternalBranchType.class.isInstance(branchType2)) {
            throw new ClassCastException("Unexpected BranchType implementation that is not an InternalBranchType: " + branchType2.getClass().getName());
        }
        return (InternalBranchType)branchType2;
    }

    static InternalBranchTypes forId(@Nonnull String id) {
        return InternalBranchTypes.forType(BranchTypes.forId(id));
    }

    static InternalBranchTypes forType(@Nonnull BranchTypes type) {
        return new InternalBranchTypes(type);
    }

    BranchTypes getType() {
        return this.type;
    }

    String getId() {
        return this.type.getId();
    }

    String getDisplayName(@Nonnull I18nService i18nService) {
        return i18nService.getMessage(I18N_PREFIX + this.type.getId(), new Object[0]);
    }

    String getDefaultPrefix() {
        return this.getId().toLowerCase() + "/";
    }
}

