/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch.automerge.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.branch.automerge.AutoMergeConfig;
import com.atlassian.stash.internal.branch.automerge.AutoMergeService;
import com.atlassian.stash.internal.branch.automerge.rest.RestAutoMerge;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.atlassian.stash.rest.util.RestResource;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/automerge")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class AutoMergeResource
extends RestResource {
    private final AutoMergeService autoMergeService;
    private final AutoMergeConfig autoMergeConfig;
    private final RefService refService;

    public AutoMergeResource(I18nService i18nService, AutoMergeService autoMergeService, AutoMergeConfig autoMergeConfig, RefService refService) {
        super(i18nService);
        this.autoMergeService = autoMergeService;
        this.autoMergeConfig = autoMergeConfig;
        this.refService = refService;
    }

    @GET
    @Path(value="path")
    public Response getMergePath(@Context Repository repository, @QueryParam(value="branchRefId") String branchRefId) {
        if (StringUtils.isBlank((String)branchRefId)) {
            return ResponseFactory.badRequest((String)"branchRefId", (String)this.i18nService.getMessage("stash.branch.automerge.rest.error.emptybranchrefid", new Object[0])).build();
        }
        Branch branch = this.resolveBranch(repository, branchRefId);
        if (branch == null) {
            return ResponseFactory.badRequest((String)"branchRefId", (String)this.i18nService.getMessage("stash.branch.automerge.rest.error.nosuchbranch", new Object[]{branchRefId})).build();
        }
        return ResponseFactory.ok((Object)((Object)new RestAutoMerge(this.autoMergeService.getAutoMerge(repository, (Ref)branch)))).build();
    }

    @GET
    @Path(value="enabled")
    public Response isAutoMergeEnabled(@Context Repository repository) {
        return this.autoMergeConfig.isEnabled(repository) ? ResponseFactory.noContent().build() : ResponseFactory.notFound().build();
    }

    @PUT
    @Path(value="enabled")
    public Response enableAutoMerge(@Context Repository repository) {
        return this.setAutoMergeEnabled(repository, true);
    }

    @DELETE
    @Path(value="enabled")
    public Response disableAutoMerge(@Context Repository repository) {
        return this.setAutoMergeEnabled(repository, false);
    }

    private Branch resolveBranch(Repository repository, String branchRefId) {
        Ref ref = this.refService.resolveRef(repository, branchRefId);
        return ref instanceof Branch ? (Branch)ref : null;
    }

    private Response setAutoMergeEnabled(Repository repository, boolean enabled) {
        this.autoMergeConfig.setEnabled(repository, enabled);
        return ResponseFactory.noContent().build();
    }
}

