/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.branch;

import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefMetadataContext;
import com.atlassian.stash.repository.RefMetadataProvider;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestChangesetMetadataProvider
implements RefMetadataProvider<Changeset> {
    private static final Logger log = LoggerFactory.getLogger(LatestChangesetMetadataProvider.class);
    private final ScmService scmService;

    public LatestChangesetMetadataProvider(ScmService scmService) {
        this.scmService = scmService;
    }

    @Nonnull
    public Map<Ref, Changeset> getMetadata(@Nonnull RefMetadataContext context) {
        Page changesets = (Page)this.scmService.getCommandFactory(context.getRepository()).commits(this.buildParameters(context), PageUtils.newRequest((int)0, (int)context.getRefs().size())).call();
        ImmutableMap changesetById = Maps.uniqueIndex((Iterable)changesets.getValues(), (Function)MinimalChangeset.TO_ID);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Ref ref : context.getRefs()) {
            Changeset changeset = (Changeset)changesetById.get(ref.getLatestChangeset());
            if (changeset != null) {
                builder.put((Object)ref, (Object)changeset);
                continue;
            }
            log.warn("Failed to find associated changeset with id {} for ref {}", (Object)ref.getLatestChangeset(), (Object)ref.getId());
        }
        return builder.build();
    }

    private CommitsCommandParameters buildParameters(RefMetadataContext metadataContext) {
        Map context = metadataContext.getContext();
        CommitsCommandParameters.Builder builder = new CommitsCommandParameters.Builder().include((Iterable)Collections2.transform((Collection)metadataContext.getRefs(), (Function)Ref.TO_LATEST_CHANGESET)).traverse(false);
        if (context.containsKey("withMessages")) {
            builder.withMessages(Boolean.TRUE.equals(context.get("withMessages")));
        }
        return builder.build();
    }
}

