/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.branch.automerge;

import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.AuditEntryConverter;
import com.atlassian.stash.branch.automerge.AutomaticMergeEvent;
import com.atlassian.stash.branch.automerge.AutomaticMergeStoppedEvent;
import com.atlassian.stash.repository.MinimalRef;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.AuditUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

public class AutomaticMergeEventConverter
implements AuditEntryConverter<AutomaticMergeEvent> {
    private static Function<RefChange, Map<String, Object>> REF_CHANGE_TO_MAP = new Function<RefChange, Map<String, Object>>(){

        public Map<String, Object> apply(RefChange change) {
            return ImmutableMap.of((Object)"ref", (Object)change.getRefId(), (Object)"from", (Object)change.getFromHash(), (Object)"to", (Object)change.getToHash());
        }
    };

    @Nonnull
    public AuditEntry convert(@Nonnull AutomaticMergeEvent event, AuditEntry.Builder builder) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"refChanges", (Object)Iterables.transform((Iterable)event.getRefChanges(), REF_CHANGE_TO_MAP)).put((Object)"mergePath", (Object)Iterables.transform(event.getMergePath(), (Function)MinimalRef.TO_ID));
        if (event instanceof AutomaticMergeStoppedEvent) {
            AutomaticMergeStoppedEvent stoppedEvent = (AutomaticMergeStoppedEvent)event;
            mapBuilder.put((Object)"reason", (Object)stoppedEvent.getReason());
        }
        ImmutableMap map = mapBuilder.build();
        return builder.action(((Object)((Object)event)).getClass()).timestamp(new Date()).details(AuditUtils.toJson((Object)map)).user(event.getUser()).target(AuditUtils.toProjectAndRepositoryString((Repository)event.getRepository())).repository(event.getRepository()).build();
    }
}

