/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum Permission {
    PROJECT_VIEW(10, 500, (Class)Project.class, new Permission[0]){

        @Override
        public boolean isGrantable() {
            return false;
        }
    }
    ,
    REPO_READ(0, 1000, Repository.class, PROJECT_VIEW),
    REPO_WRITE(1, 3000, Repository.class, REPO_READ),
    REPO_ADMIN(8, 5000, Repository.class, REPO_WRITE),
    PROJECT_READ(2, 2000, Project.class, REPO_READ),
    PROJECT_WRITE(3, 4000, Project.class, PROJECT_READ, REPO_WRITE),
    PROJECT_ADMIN(4, 6000, Project.class, PROJECT_WRITE, REPO_ADMIN),
    LICENSED_USER(9, 0, null, new Permission[0]),
    PROJECT_CREATE(5, 7000, null, LICENSED_USER),
    ADMIN(6, 9000, null, new Permission[]{PROJECT_CREATE, PROJECT_ADMIN}){

        @Override
        public boolean isGrantableToAll() {
            return false;
        }
    }
    ,
    SYS_ADMIN(7, 10000, null, new Permission[]{ADMIN}){

        @Override
        public boolean isGrantableToAll() {
            return false;
        }
    };

    private static Map<Integer, Permission> idToPermissionMap;
    private static Map<Integer, Permission> weightToPermissionMap;
    private final int id;
    private final Set<Permission> inheritedPermissions;
    private final Class<?> resourceClass;
    private final int weight;
    private Set<Permission> implyingPermissions;
    private Set<Permission> inheritingPermissions;

    private Permission(int id, int weight, Class<?> resourceClass, Permission ... inherited) {
        this.id = id;
        this.resourceClass = resourceClass;
        this.weight = weight;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Permission p : inherited) {
            this.appendInheritedPermissions((ImmutableSet.Builder<Permission>)builder, p);
        }
        this.inheritedPermissions = builder.build();
    }

    private void appendInheritedPermissions(ImmutableSet.Builder<Permission> builder, Permission p) {
        builder.add((Object)p);
        for (Permission perm : p.getInheritedPermissions()) {
            this.appendInheritedPermissions(builder, perm);
        }
    }

    public int getId() {
        return this.id;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isResource(Class<?> resourceClass) {
        return this.resourceClass != null && this.resourceClass.isAssignableFrom(resourceClass);
    }

    public boolean isGlobal() {
        return this.resourceClass == null;
    }

    public boolean isResource() {
        return !this.isGlobal();
    }

    public Set<Permission> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    public Set<Permission> getInheritingPermissions() {
        if (this.inheritingPermissions == null) {
            EnumSet<Permission> perms = EnumSet.of(this);
            for (Permission p : Permission.values()) {
                if (!p.getInheritedPermissions().contains((Object)this)) continue;
                perms.add(p);
            }
            this.inheritingPermissions = Collections.unmodifiableSet(perms);
        }
        return this.inheritingPermissions;
    }

    public Set<Permission> getImplyingPermissions() {
        if (this.implyingPermissions == null) {
            EnumSet<Permission> inheriting = EnumSet.noneOf(Permission.class);
            inheriting.addAll(this.getInheritingPermissions());
            inheriting.remove((Object)this);
            this.implyingPermissions = Collections.unmodifiableSet(inheriting);
        }
        return this.implyingPermissions;
    }

    public boolean isGrantableToAll() {
        return this.isGrantable();
    }

    public boolean isGrantable() {
        return true;
    }

    public static Set<Permission> getGlobalPermissions() {
        return Sets.filter(EnumSet.allOf(Permission.class), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return permission.isGlobal();
            }
        });
    }

    public static Set<Permission> getPermissionsOn(final Class<?> resourceClass) {
        return Sets.filter(EnumSet.allOf(Permission.class), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission permission) {
                return permission.isResource(resourceClass);
            }
        });
    }

    @Nullable
    public static Permission fromId(int id) {
        if (idToPermissionMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Permission permission : Permission.values()) {
                builder.put((Object)permission.getId(), (Object)permission);
            }
            idToPermissionMap = builder.build();
        }
        return idToPermissionMap.get(id);
    }

    @Nullable
    public static Permission fromWeight(int weight) {
        if (weightToPermissionMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Permission permission : Permission.values()) {
                builder.put((Object)permission.getWeight(), (Object)permission);
            }
            weightToPermissionMap = builder.build();
        }
        return weightToPermissionMap.get(weight);
    }

    @Nullable
    public static Permission max(Permission p1, Permission p2) {
        if (p1 == null) {
            return p2;
        }
        return p2 == null || p1.getWeight() > p2.getWeight() ? p1 : p2;
    }
}

