/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.audit;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditEntry {
    private final Project project;
    private final Repository repository;
    private final StashUser user;
    private final String details;
    private final long timestamp;
    private final String action;
    private final String sourceIpAddress;
    private final String target;

    private AuditEntry(@Nonnull Date timestamp, @Nonnull String action, @Nonnull String target, @Nullable String sourceIpAddress, @Nullable String details, @Nullable StashUser user, @Nullable Project project, @Nullable Repository repository) {
        this.project = project;
        this.repository = repository;
        this.details = details;
        this.user = user;
        this.sourceIpAddress = sourceIpAddress;
        this.timestamp = ((Date)Preconditions.checkNotNull((Object)timestamp)).getTime();
        this.action = (String)Preconditions.checkNotNull((Object)action);
        this.target = (String)Preconditions.checkNotNull((Object)target);
    }

    @Nullable
    public StashUser getUser() {
        return this.user;
    }

    @Nullable
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }

    @Nonnull
    public long getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public String getAction() {
        return this.action;
    }

    @Nonnull
    public String getTarget() {
        return this.target;
    }

    @Nullable
    public String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    public static class Builder {
        private Project project;
        private Repository repository;
        private StashUser user;
        private String action;
        private String target;
        private Date timestamp;
        private String details;
        private String sourceIpAddress;

        public AuditEntry build() {
            return new AuditEntry(this.timestamp, this.action, this.target, this.sourceIpAddress, this.details, this.user, this.project, this.repository);
        }

        public Builder sourceIpAddress(String val) {
            this.sourceIpAddress = val;
            return this;
        }

        public Builder project(Project val) {
            this.project = val;
            return this;
        }

        public Builder repository(Repository val) {
            this.repository = val;
            if (this.project == null) {
                this.project = val.getProject();
            }
            return this;
        }

        public Builder user(StashUser val) {
            this.user = val;
            return this;
        }

        public Builder action(Class val) {
            this.action = val.getSimpleName();
            return this;
        }

        public Builder action(String val) {
            this.action = val;
            return this;
        }

        public Builder target(String val) {
            this.target = val;
            return this;
        }

        public Builder timestamp(Date val) {
            this.timestamp = val;
            return this;
        }

        public Builder details(String val) {
            this.details = val;
            return this;
        }

        public Builder timestamp(long timestamp) {
            return this.timestamp(new Date(timestamp));
        }
    }
}

