/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.PullRequestDirection;
import com.atlassian.stash.pull.PullRequestOrder;
import com.atlassian.stash.pull.PullRequestParticipantSearchRequest;
import com.atlassian.stash.pull.PullRequestState;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestSearchRequest {
    public static final int MAXIMUM_BRANCHES_TO_SEARCH = 100;
    private final Collection<String> fromRefIds;
    private final Integer fromRepositoryId;
    private final PullRequestOrder order;
    private final Collection<PullRequestParticipantSearchRequest> participants;
    private final PullRequestState state;
    private final Collection<String> toRefIds;
    private final Integer toRepositoryId;
    private final boolean withProperties;

    private PullRequestSearchRequest(Builder builder) {
        this.fromRefIds = builder.fromRefIds.build();
        this.fromRepositoryId = builder.fromRepositoryId;
        this.order = builder.order;
        this.participants = builder.participants.build();
        this.state = builder.state;
        this.toRefIds = builder.toRefIds.build();
        this.toRepositoryId = builder.toRepositoryId;
        this.withProperties = builder.withProperties;
        if (this.fromRefIds.size() + this.toRefIds.size() > 100) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " does not allow searching more than " + 100 + " branches");
        }
    }

    @Nonnull
    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    @Nullable
    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    @Nullable
    public PullRequestOrder getOrder() {
        return this.order;
    }

    @Nonnull
    public Collection<PullRequestParticipantSearchRequest> getParticipants() {
        return this.participants;
    }

    @Nullable
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    @Nullable
    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    @Deprecated
    public boolean isWithAttributes() {
        return this.withProperties;
    }

    public boolean isWithProperties() {
        return this.withProperties;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> fromRefIds = ImmutableSet.builder();
        private final ImmutableList.Builder<PullRequestParticipantSearchRequest> participants = ImmutableList.builder();
        private final ImmutableSet.Builder<String> toRefIds = ImmutableSet.builder();
        private Integer fromRepositoryId;
        private PullRequestOrder order;
        private PullRequestState state;
        private Integer toRepositoryId;
        private boolean withProperties = true;

        @Nonnull
        public PullRequestSearchRequest build() {
            return new PullRequestSearchRequest(this);
        }

        @Nonnull
        public Builder repositoryAndBranch(@Nullable PullRequestDirection direction, @Nullable Integer repositoryId, @Nullable String branch) {
            if (direction == PullRequestDirection.OUTGOING) {
                Builder.addIf(NOT_BLANK, this.fromRefIds, branch);
                if (this.fromRepositoryId != null && !this.fromRepositoryId.equals(repositoryId)) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.fromRepositoryId = repositoryId;
            } else {
                Builder.addIf(NOT_BLANK, this.toRefIds, branch);
                if (this.toRepositoryId != null && !this.toRepositoryId.equals(repositoryId)) {
                    throw new IllegalStateException("Repository ID is already set to a different value");
                }
                this.toRepositoryId = repositoryId;
            }
            return this;
        }

        @Nonnull
        public Builder fromRepositoryId(@Nullable Integer repositoryId) {
            this.fromRepositoryId = repositoryId;
            return this;
        }

        @Nonnull
        public Builder fromBranchId(@Nullable String branchId) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, branchId);
            return this;
        }

        @Nonnull
        public Builder fromBranchIds(@Nullable Iterable<String> branchIds) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, branchIds);
            return this;
        }

        @Nonnull
        public Builder fromRefId(@Nullable String refId) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, refId);
            return this;
        }

        @Nonnull
        public Builder fromRefIds(@Nullable Iterable<String> refIds) {
            Builder.addIf(NOT_BLANK, this.fromRefIds, refIds);
            return this;
        }

        @Nonnull
        public Builder order(@Nullable PullRequestOrder order) {
            this.order = order;
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipantSearchRequest value) {
            Builder.addIf(Predicates.notNull(), this.participants, value);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipantSearchRequest> values) {
            Builder.addIf(Predicates.notNull(), this.participants, values);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState state) {
            this.state = state;
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer repositoryId) {
            this.toRepositoryId = repositoryId;
            return this;
        }

        @Nonnull
        public Builder toBranchId(@Nullable String branchId) {
            Builder.addIf(NOT_BLANK, this.toRefIds, branchId);
            return this;
        }

        @Nonnull
        public Builder toBranchIds(@Nullable Iterable<String> branchIds) {
            Builder.addIf(NOT_BLANK, this.toRefIds, branchIds);
            return this;
        }

        @Nonnull
        public Builder toRefId(@Nullable String refId) {
            Builder.addIf(NOT_BLANK, this.toRefIds, refId);
            return this;
        }

        @Nonnull
        public Builder toRefIds(@Nullable Iterable<String> refIds) {
            Builder.addIf(NOT_BLANK, this.toRefIds, refIds);
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder withAttributes(boolean withAttributes) {
            this.withProperties = withAttributes;
            return this;
        }

        @Nonnull
        public Builder withProperties(boolean withProperties) {
            this.withProperties = withProperties;
            return this;
        }
    }
}

