/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.ScmType;
import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import java.util.HashMap;
import java.util.Map;

public interface Repository {
    public Integer getId();

    @RequiredString(size=64, regexp="[\\p{Alnum}][\\w\\-\\.]*")
    public String getSlug();

    @RequiredString(size=64, regexp="[\\p{Alnum}][\\w\\-\\. ]*", message="{com.atlassian.stash.validation.repository.name.pattern.message}")
    public String getName();

    public ScmType getScmType();

    public Repository getOrigin();

    public Project getProject();

    public State getState();

    @OptionalString(size=255)
    public String getStatusMessage();

    public static enum State {
        INITIALISING(0, "Initialising"),
        AVAILABLE(1, "Available"),
        INITIALISATION_FAILED(2, "Failed to initialise repository");

        private static Map<Integer, State> map;
        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = statusMessage;
        }

        public int getId() {
            return this.id;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public static State fromId(int id) {
            if (map == null) {
                map = new HashMap<Integer, State>();
                for (State state : State.values()) {
                    map.put(state.getId(), state);
                }
            }
            return map.get(id);
        }
    }
}

