/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.webpanel;

import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.soy.impl.DevMode;
import com.atlassian.soy.renderer.SoyException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TemplateAddressing {
    private static final Logger log = LoggerFactory.getLogger(TemplateAddressing.class);

    TemplateAddressing() {
    }

    public static Address parseTemplateAddress(String templateAddress, String callingPluginKey) throws SoyException {
        Address address;
        try {
            address = TemplateAddressing.parseAtlassianTemplateAddress(templateAddress, callingPluginKey);
        }
        catch (SoyException e) {
            address = TemplateAddressing.parseStashCompatibleTemplateAddress(templateAddress);
        }
        return address;
    }

    private static Address parseAtlassianTemplateAddress(String templateAddress, String callingPluginKey) throws SoyException {
        String completeKey = StringUtils.substringBefore((String)templateAddress, (String)"/");
        String templateName = StringUtils.substringAfter((String)templateAddress, (String)"/");
        if (StringUtils.isEmpty((String)completeKey) || StringUtils.isEmpty((String)templateName)) {
            throw TemplateAddressing.badTemplateName(templateAddress);
        }
        if (StringUtils.countMatches((String)completeKey, (String)":") != 1) {
            throw TemplateAddressing.badTemplateName(templateAddress);
        }
        String pluginKey = StringUtils.substringBefore((String)completeKey, (String)":");
        String moduleKey = StringUtils.substringAfter((String)completeKey, (String)":");
        if (StringUtils.isEmpty((String)pluginKey) || ".".equals(pluginKey)) {
            pluginKey = callingPluginKey;
        }
        if (StringUtils.isEmpty((String)pluginKey) || StringUtils.isEmpty((String)moduleKey)) {
            throw TemplateAddressing.badTemplateName(templateAddress);
        }
        return new Address(new ModuleCompleteKey(pluginKey, moduleKey), templateName);
    }

    private static Address parseStashCompatibleTemplateAddress(String templateAddress) throws SoyException {
        String[] parts = templateAddress.split(",", 2);
        if (parts.length != 2) {
            throw TemplateAddressing.badTemplateName(templateAddress);
        }
        if (DevMode.isDevMode()) {
            log.warn("Stash style pluginKey:moduleKey,templateName addressing is deprecated and will be removed in the future.  Please update to pluginKey:moduleKey/templateName addressing");
        }
        return new Address(new ModuleCompleteKey(parts[0]), parts[1]);
    }

    private static SoyException badTemplateName(String templateAddress) {
        return new SoyException(String.format("Template name must be in the form 'pluginKey:moduleKey/templateAddress' - '%s'", templateAddress));
    }

    static class Address {
        private final ModuleCompleteKey completeKey;
        private final String templateName;

        Address(ModuleCompleteKey completeKey, String templateName) {
            this.completeKey = completeKey;
            this.templateName = templateName;
        }

        public ModuleCompleteKey getCompleteKey() {
            return this.completeKey;
        }

        public String getTemplateName() {
            return this.templateName;
        }
    }
}

