/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.functions;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.web.context.HttpContext;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.base.CharEscaper;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

@Singleton
public class ContextFunction
implements SoyJsSrcFunction,
SoyTofuFunction {
    private final ApplicationProperties applicationProperties;
    private final HttpContext httpContext;

    @Inject
    public ContextFunction(ApplicationProperties applicationProperties, HttpContext httpContext) {
        this.applicationProperties = applicationProperties;
        this.httpContext = httpContext;
    }

    private static String stripTrailingSlash(String base) {
        return StringUtils.chomp((String)base, (String)"/");
    }

    public String getName() {
        return "contextPath";
    }

    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    public JsExpr computeForJsSrc(List<JsExpr> args) {
        CharEscaper jsEscaper = CharEscapers.javascriptEscaper();
        return new JsExpr('\"' + jsEscaper.escape(this.getContextPath()) + '\"', Integer.MAX_VALUE);
    }

    public SoyData computeForTofu(List<SoyData> soyDatas) {
        return StringData.forValue((String)this.getContextPath());
    }

    private String getContextPath() {
        HttpServletRequest request = this.httpContext.getRequest();
        return request != null ? request.getContextPath() : this.getContextPathFromBaseUrl();
    }

    private String getContextPathFromBaseUrl() {
        String baseUrl = ContextFunction.stripTrailingSlash(this.applicationProperties.getBaseUrl());
        try {
            return new URI(baseUrl).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

