/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.data;

import com.atlassian.soy.impl.data.EnumData;
import com.atlassian.soy.impl.data.LazySoyMapData;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import com.atlassian.soy.renderer.SoyDataMapper;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Callables;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class SoyDataConverter {
    private final List<SoyDataMapper> customMappers;

    public SoyDataConverter(List<SoyDataMapper> customMappers) {
        this.customMappers = customMappers;
    }

    public <K, V> SoyMapData convertToSoyMapData(Map<K, V> map) {
        SoyMapData soyMapData = new SoyMapData();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            V value = entry.getValue();
            Object soyValue = this.convertObject(value);
            soyMapData.put(new Object[]{key, soyValue});
        }
        return soyMapData;
    }

    public <V> SoyListData convertToSoyListData(Iterable<V> list) {
        SoyListData listData = new SoyListData();
        for (V o : list) {
            listData.add(new Object[]{this.convertObject(o)});
        }
        return listData;
    }

    public SoyData convertToSoyData(Object value) {
        return SoyData.createFromExistingData((Object)this.convertObject(value));
    }

    Object convertObject(Object value) {
        if (value == null || value instanceof Boolean || value instanceof Integer || value instanceof Double || value instanceof Float || value instanceof String) {
            return value;
        }
        if (value instanceof Short || value instanceof Byte) {
            return ((Number)value).intValue();
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                return longValue.intValue();
            }
            return longValue.doubleValue();
        }
        if (value instanceof Map) {
            return this.convertToSoyMapData((Map)value);
        }
        if (value instanceof Iterable) {
            return this.convertToSoyListData((Iterable)value);
        }
        if (value.getClass().isArray()) {
            return this.convertToSoyListData(Arrays.asList((Object[])value));
        }
        if (value instanceof Enum) {
            return new EnumData((Enum)value);
        }
        CustomSoyDataMapper mapper = value.getClass().getAnnotation(CustomSoyDataMapper.class);
        if (mapper != null) {
            return this.customConvert(value, mapper.value());
        }
        return new LazySoyMapData(this.makeCallable(value), this);
    }

    private Callable makeCallable(Object value) {
        if (value instanceof Callable) {
            return (Callable)value;
        }
        return Callables.returning((Object)value);
    }

    private Object customConvert(Object object, String mapper) {
        for (SoyDataMapper customMapper : this.customMappers) {
            if (!customMapper.getName().equals(mapper)) continue;
            return this.convertToSoyData(customMapper.convert(object));
        }
        throw new IllegalStateException("Could not find custom mapper " + mapper + " for class " + object.getClass());
    }

    public static Object convertFromSoyData(SoyData data) {
        if (data instanceof LazySoyMapData) {
            return ((LazySoyMapData)data).getDelegate();
        }
        if (data instanceof SoyMapData) {
            return Maps.transformValues((Map)((SoyMapData)data).asMap(), (Function)new Function<SoyData, Object>(){

                public Object apply(SoyData from) {
                    return SoyDataConverter.convertFromSoyData(from);
                }
            });
        }
        if (data instanceof SoyListData) {
            return Lists.transform((List)((SoyListData)data).asList(), (Function)new Function<SoyData, Object>(){

                public Object apply(SoyData from) {
                    return SoyDataConverter.convertFromSoyData(from);
                }
            });
        }
        if (data instanceof EnumData) {
            return ((EnumData)data).getValue();
        }
        if (data instanceof StringData) {
            return data.stringValue();
        }
        if (data instanceof IntegerData) {
            return ((IntegerData)data).getValue();
        }
        if (data instanceof BooleanData) {
            return ((BooleanData)data).getValue();
        }
        if (data instanceof FloatData) {
            return ((FloatData)data).getValue();
        }
        return data == NullData.INSTANCE ? null : data.stringValue();
    }
}

