/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl.data;

import com.atlassian.soy.impl.data.SoyDataConverter;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.NullData;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.PropertyUtils;

class LazySoyMapData
extends SoyMapData {
    private final Cache<String, SoyData> cache;
    private final LazyReference<Object> delegate;

    LazySoyMapData(final Callable<Object> objectSource, final SoyDataConverter soyDataConverter) {
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, SoyData>(){

            public SoyData load(String from) {
                Object value;
                try {
                    value = "class".equals(from) ? null : PropertyUtils.getProperty((Object)LazySoyMapData.this.delegate.get(), (String)from);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    value = null;
                }
                return SoyData.createFromExistingData((Object)soyDataConverter.convertObject(value));
            }
        });
        this.delegate = new LazyReference<Object>(){

            protected Object create() throws Exception {
                return objectSource.call();
            }
        };
    }

    public Object getDelegate() {
        return this.delegate.get();
    }

    public SoyData getSingle(String key) {
        SoyData soyData = super.getSingle(key);
        return soyData != null && soyData != NullData.INSTANCE ? soyData : (SoyData)this.cache.getUnchecked((Object)key);
    }

    public String toString() {
        return this.getDelegate().toString();
    }
}

