/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TemplateSetFactory {
    private static final Logger log = LoggerFactory.getLogger(TemplateSetFactory.class);
    private final PluginAccessor pluginAccessor;
    private final ServletContextFactory servletContextFactory;
    private final Cache<String, Set<URL>> templateSetCache;

    TemplateSetFactory(PluginAccessor pluginAccessor, ServletContextFactory servletContextFactory, int injectorCacheExpiryTime, TimeUnit injectorCacheExpiryTimeUnit) {
        this.pluginAccessor = pluginAccessor;
        this.servletContextFactory = servletContextFactory;
        CacheLoader<String, Set<URL>> findTemplatesFunction = new CacheLoader<String, Set<URL>>(){

            public Set<URL> load(String moduleKey) {
                return TemplateSetFactory.this.findRequiredTemplates(moduleKey);
            }
        };
        this.templateSetCache = CacheBuilder.newBuilder().expireAfterWrite((long)injectorCacheExpiryTime, injectorCacheExpiryTimeUnit).build((CacheLoader)findTemplatesFunction);
    }

    Set<URL> get(String completeModuleKey) {
        return (Set)this.templateSetCache.getUnchecked((Object)completeModuleKey);
    }

    void clear() {
        this.templateSetCache.invalidateAll();
    }

    private Set<URL> findRequiredTemplates(String pluginModuleKey) {
        log.debug("Found Soy template files for '{}'", (Object)pluginModuleKey);
        TemplateSetBuilder templateSetBuilder = new TemplateSetBuilder();
        templateSetBuilder.addTemplatesForTree(pluginModuleKey);
        Set result = templateSetBuilder.build();
        log.debug("Found Soy template files for '{}' was {}", (Object)pluginModuleKey, (Object)result);
        return result;
    }

    private class TemplateSetBuilder {
        private final Set<URL> fileSet = Sets.newHashSet();
        private final Set<String> alreadyAddedModules = Sets.newHashSet();

        private TemplateSetBuilder() {
        }

        private void addTemplatesForTree(String completeModuleKey) {
            if (this.alreadyAddedModules.contains(completeModuleKey)) {
                return;
            }
            this.alreadyAddedModules.add(completeModuleKey);
            ModuleDescriptor moduleDescriptor = TemplateSetFactory.this.pluginAccessor.getEnabledPluginModule(completeModuleKey);
            if (moduleDescriptor == null) {
                throw new IllegalStateException("Required plugin module " + completeModuleKey + " was either missing or disabled");
            }
            if (moduleDescriptor instanceof WebResourceModuleDescriptor) {
                this.addTemplatesForTree((WebResourceModuleDescriptor)moduleDescriptor);
            }
            this.addSoyTemplateResources(moduleDescriptor);
        }

        private void addTemplatesForTree(WebResourceModuleDescriptor webResourceModuleDescriptor) {
            for (String dependencyModuleKey : webResourceModuleDescriptor.getDependencies()) {
                this.addTemplatesForTree(dependencyModuleKey);
            }
        }

        private void addSoyTemplateResources(ModuleDescriptor<?> moduleDescriptor) {
            for (ResourceDescriptor resource : moduleDescriptor.getResourceDescriptors()) {
                URL url;
                if (!this.isSoyTemplate(resource) || (url = this.getSoyResourceURL(moduleDescriptor, resource)) == null) continue;
                this.fileSet.add(url);
            }
        }

        private boolean isSoyTemplate(ResourceDescriptor resource) {
            return StringUtils.endsWith((String)resource.getLocation(), (String)".soy");
        }

        private URL getSoyResourceURL(ModuleDescriptor moduleDescriptor, ResourceDescriptor resource) {
            String sourceParam = resource.getParameter("source");
            if ("webContextStatic".equalsIgnoreCase(sourceParam)) {
                try {
                    return TemplateSetFactory.this.servletContextFactory.getServletContext().getResource(resource.getLocation());
                }
                catch (MalformedURLException e) {
                    log.error("Ignoring soy resource. Could not locate soy with location: " + resource.getLocation());
                    return null;
                }
            }
            return moduleDescriptor.getPlugin().getResource(resource.getLocation());
        }

        private Set<URL> build() {
            return ImmutableSet.copyOf(this.fileSet);
        }
    }
}

