/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.auth;

import com.atlassian.seraph.config.SecurityConfig;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AuthType {
    NONE,
    COOKIE,
    BASIC,
    ANY;

    public static final String DEFAULT_ATTRIBUTE = "os_authTypeDefault";

    public static AuthType getAuthTypeInformation(HttpServletRequest request, SecurityConfig config) {
        String authTypeParamName = config.getAuthType();
        String authType = request.getParameter(authTypeParamName);
        if (authType == null) {
            authType = (String)request.getAttribute(DEFAULT_ATTRIBUTE);
        }
        if (authType == null) {
            return NONE;
        }
        try {
            return AuthType.valueOf(authType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }
}

