package com.atlassian.seraph.auth;

import java.security.Principal;

public class AuthenticationContextImpl implements AuthenticationContext
{
    private static final ThreadLocal<Principal> threadLocal = new ThreadLocal<Principal>();

    public Principal getUser()
    {
        return threadLocal.get();
    }

    public void setUser(final Principal user)
    {
        threadLocal.set(user);
    }

    public void clearUser()
    {
        setUser(null);
    }
}
