package com.atlassian.seraph.cookie;

/**
 * Insecure cooking encoder that uses an XOR mask with character offsets to "encode" the username and password
 *
 * @deprecated replaced by the {@link com.atlassian.seraph.service.rememberme.RememberMeService} code
 */
public class InsecureCookieEncoder implements CookieEncoder
{
    // Character used to separate username and password in persistent cookies.
    // 0x13 == "Device Control 3" non-printing ASCII char. Unlikely to appear in a username
    private static final char DELIMITER = 0x13;

    // "Tweakable" parameters for the cookie encoding. NOTE: changing these
    // and recompiling this class will essentially invalidate old cookies.
    private final static int ENCODE_XORMASK = 0x5A;
    private final static char ENCODE_CHAR_OFFSET1 = 'C';
    private final static char ENCODE_CHAR_OFFSET2 = 'i';

    public String encodePasswordCookie(final String username, final String password, final String encoding)
    {
        final StringBuffer buf = new StringBuffer();
        if ((username != null) && (password != null))
        {
            final char offset1 = ((encoding != null) && (encoding.length() > 1)) ? encoding.charAt(1) : InsecureCookieEncoder.ENCODE_CHAR_OFFSET1;
            final char offset2 = ((encoding != null) && (encoding.length() > 2)) ? encoding.charAt(2) : InsecureCookieEncoder.ENCODE_CHAR_OFFSET2;

            final byte[] bytes = (username + InsecureCookieEncoder.DELIMITER + password).getBytes();
            int b;

            for (int n = 0; n < bytes.length; n++)
            {
                b = bytes[n] ^ (InsecureCookieEncoder.ENCODE_XORMASK + n);
                buf.append((char) (offset1 + (b & 0x0F)));
                buf.append((char) (offset2 + ((b >> 4) & 0x0F)));
            }
        }
        return buf.toString();
    }

    public String[] decodePasswordCookie(String cookieVal, final String encoding)
    {
        // check that the cookie value isn't null or zero-length
        if ((cookieVal == null) || (cookieVal.length() <= 0))
        {
            return null;
        }

        final char offset1 = ((encoding != null) && (encoding.length() > 1)) ? encoding.charAt(1) : InsecureCookieEncoder.ENCODE_CHAR_OFFSET1;
        final char offset2 = ((encoding != null) && (encoding.length() > 2)) ? encoding.charAt(2) : InsecureCookieEncoder.ENCODE_CHAR_OFFSET2;

        // decode the cookie value
        final char[] chars = cookieVal.toCharArray();
        final byte[] bytes = new byte[chars.length / 2];
        int b;
        for (int n = 0, m = 0; n < bytes.length; n++)
        {
            b = chars[m++] - offset1;
            b |= (chars[m++] - offset2) << 4;
            bytes[n] = (byte) (b ^ (InsecureCookieEncoder.ENCODE_XORMASK + n));
        }
        cookieVal = new String(bytes);
        final int pos = cookieVal.indexOf(InsecureCookieEncoder.DELIMITER);
        final String username = (pos < 0) ? "" : cookieVal.substring(0, pos);
        final String password = (pos < 0) ? "" : cookieVal.substring(pos + 1);

        return new String[] { username, password };
    }

    /**
     * Builds a cookie string containing a username and password.
     * <p>
     * Note: with open source this is not really secure, but it prevents users from snooping the cookie file of others and by changing the XOR mask
     * and character offsets, you can easily tweak results.
     * 
     * @param username
     *            The username.
     * @param password
     *            The password.
     * @return String encoding the input parameters, an empty string if one of the arguments equals <code>null</code>.
     * @deprecated only here to support {@link com.atlassian.seraph.util.CookieUtils#encodePasswordCookie(String, String)}
     */
    public String encodePasswordCookie(final String username, final String password)
    {
        return encodePasswordCookie(username, password, new String(new char[] { InsecureCookieEncoder.DELIMITER, InsecureCookieEncoder.ENCODE_CHAR_OFFSET1, InsecureCookieEncoder.ENCODE_CHAR_OFFSET2 }));
    }

    /**
     * Decodes a cookie string containing a username and password.
     * 
     * @param cookieVal
     *            The cookie value.
     * @return String[] containing the username at index 0 and the password at index 1, or <code>{ null, null }</code> if cookieVal equals
     *         <code>null</code> or the empty string.
     * @deprecated only here to support {@link com.atlassian.seraph.util.CookieUtils#decodePasswordCookie(String)}
     */
    public String[] decodePasswordCookie(final String cookieVal)
    {
        return decodePasswordCookie(cookieVal, new String(new char[] { InsecureCookieEncoder.DELIMITER, InsecureCookieEncoder.ENCODE_CHAR_OFFSET1, InsecureCookieEncoder.ENCODE_CHAR_OFFSET2 }));
    }
}
