/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.cookie;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class HttpOnlyCookieKit {
    private static final String COOKIE_EXPIRE_DF = "EEE, d MMM yyyy HH:mm:ss 'GMT'";
    private static final String tspecials = ",;";

    public static void setCookie(HttpServletResponse httpServletResponse, Cookie cookie) {
        boolean greaterThanV0 = cookie.getVersion() > 0;
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.getName()).append("=").append(HttpOnlyCookieKit.esc(cookie.getValue()));
        if (greaterThanV0) {
            sb.append("; Version=").append(cookie.getVersion());
        }
        if (greaterThanV0 && StringUtils.isNotBlank((String)cookie.getComment())) {
            sb.append("; Comment=").append(HttpOnlyCookieKit.esc(cookie.getComment()));
        }
        if (StringUtils.isNotBlank((String)cookie.getDomain())) {
            sb.append("; Domain=").append(HttpOnlyCookieKit.esc(cookie.getDomain()));
        }
        if (cookie.getMaxAge() >= 0) {
            if (greaterThanV0) {
                sb.append("; Max-Age=").append(cookie.getMaxAge());
            } else {
                sb.append("; Expires=").append(HttpOnlyCookieKit.expires(cookie));
            }
        }
        if (StringUtils.isNotBlank((String)cookie.getPath())) {
            sb.append("; Path=").append(HttpOnlyCookieKit.esc(cookie.getPath()));
        }
        if (cookie.getSecure()) {
            sb.append("; Secure");
        }
        sb.append("; HttpOnly");
        httpServletResponse.addHeader("Set-Cookie", sb.toString());
    }

    private static String esc(String value) {
        if (HttpOnlyCookieKit.isToken(value)) {
            return value;
        }
        return "\"" + value + "\"";
    }

    private static String expires(Cookie cookie) {
        int msMaxAge = cookie.getMaxAge() * 1000;
        SimpleDateFormat df = new SimpleDateFormat(COOKIE_EXPIRE_DF);
        return df.format(new Date(System.currentTimeMillis() + (long)msMaxAge));
    }

    private static boolean isToken(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }
}

