package com.atlassian.seraph.service.rememberme;

import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.spi.rememberme.RememberMeConfiguration;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * This default implementation of {@link com.atlassian.seraph.spi.rememberme.RememberMeConfiguration}
 */
public class DefaultRememberMeConfiguration implements RememberMeConfiguration
{
    public static final int TWO_WEEKS = 2 * 7 * 24 * 60 * 60;
    private final SecurityConfig config;


    public DefaultRememberMeConfiguration()
    {
        this(SecurityConfigFactory.getInstance());
    }

    public DefaultRememberMeConfiguration(final SecurityConfig config)
    {
        this.config = config;
    }

    /**
     * This app may needs to determine this.  See JRA-10508.  By default we load it from the same place that Serpah uses
     * for backwards compatibility.
     *
     * @return true if {@link javax.servlet.http.Cookie#setSecure(boolean)} should be called with true
     */
    public boolean isInsecureCookieAlwaysUsed()
    {
        return config.isInsecureCookie();
    }


    /**
     * By default we take the conservative route and not use HttpOnly cookies.  However an application
     * can decide to make it more secure and return true.  We had initial troubles in JIRA and hence
     * we took the conservative route.  Eventually we want to get around these problems 
     * 
     * @return
     */
    public boolean isCookieHttpOnly()
    {
        return false;
    }

    public String getCookieName()
    {
        return config.getLoginCookieKey();
    }

    public int getCookieMaxAgeInSeconds()
    {
        int maxAge = config.getAutoLoginCookieAge();
        if (maxAge <= 0)
        {
            maxAge = TWO_WEEKS;
        }
        return maxAge;
    }

    public String getCookieDomain(final HttpServletRequest httpServletRequest)
    {
        return null;
    }

    public String getCookiePath(final HttpServletRequest httpServletRequest)
    {
        final String path = config.getLoginCookiePath();
        if (path != null)
        {
            return path;
        }
        final String contextPath = httpServletRequest.getContextPath();
        if (StringUtils.isBlank(contextPath))
        {
            return "/";
        }
        return contextPath;
    }
}
