/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.simpleserver;

import com.atlassian.pageobjects.DefaultProductInstance;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.TestedProductFactory;
import com.atlassian.webdriver.testing.runner.ProductContextRunner;
import com.atlassian.webdriver.testing.simpleserver.SimpleServer;
import java.util.Optional;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class SimpleServerRunner
extends ProductContextRunner {
    private final SimpleServer server = Optional.ofNullable(Integer.getInteger("simpleserver.port")).map(SimpleServer::new).orElseGet(SimpleServer::new);

    public SimpleServerRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    @Override
    protected TestedProduct<?> createProduct(Class<? extends TestedProduct<?>> testedProductClass) {
        int port = this.startServer();
        return TestedProductFactory.create(testedProductClass, (ProductInstance)this.createProductInstance(port), null);
    }

    @Override
    protected Statement classBlock(RunNotifier notifier) {
        final Statement original = super.classBlock(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    original.evaluate();
                }
                finally {
                    SimpleServerRunner.this.shutdownServer();
                }
            }
        };
    }

    private int startServer() {
        try {
            this.server.startServer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.server.getPort();
    }

    private ProductInstance createProductInstance(int port) {
        return new DefaultProductInstance("http://localhost:" + port, "testapp", port, "/");
    }

    private void shutdownServer() throws Exception {
        this.server.stopServer();
    }
}

