/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.ie;

import com.atlassian.browsers.BrowserConfig;
import java.io.File;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IeBrowser {
    private static final Logger log = LoggerFactory.getLogger(IeBrowser.class);
    public static final String IE_SERVICE_EXECUTABLE = "IEDriverServer.exe";

    private IeBrowser() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static InternetExplorerDriver createIeDriver(@Nullable String browserPath, @Nullable BrowserConfig config) {
        return IeBrowser.createIeDriver(browserPath, config, null);
    }

    public static InternetExplorerDriver createIeDriver(@Nullable String browserPath, @Nullable BrowserConfig config, @Nullable Capabilities capabilities) {
        if (IeBrowser.noBrowserPath(browserPath) && IeBrowser.noServicePath(config)) {
            return IeBrowser.createDefaultDriver();
        }
        InternetExplorerDriverService service = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)IeBrowser.setBrowserExecutablePath(browserPath, IeBrowser.setServiceExecutablePath(config, new InternetExplorerDriverService.Builder())).usingAnyFreePort()).build();
        return new InternetExplorerDriver(service, new InternetExplorerOptions(capabilities));
    }

    public static InternetExplorerDriver createDefaultDriver() {
        return new InternetExplorerDriver();
    }

    private static boolean noBrowserPath(@Nullable String browserPath) {
        return browserPath == null;
    }

    private static boolean hasServicePath(@Nullable BrowserConfig config) {
        return config != null && config.getProfilePath() != null;
    }

    private static boolean noServicePath(@Nullable BrowserConfig config) {
        return !IeBrowser.hasServicePath(config);
    }

    private static InternetExplorerDriverService.Builder setServiceExecutablePath(BrowserConfig browserConfig, InternetExplorerDriverService.Builder builder) {
        File profilePath;
        File ieDriverFile;
        if (IeBrowser.hasServicePath(browserConfig) && (ieDriverFile = new File(profilePath = new File(browserConfig.getProfilePath()), IE_SERVICE_EXECUTABLE)).isFile()) {
            builder.usingDriverExecutable(ieDriverFile);
        }
        return builder;
    }

    private static InternetExplorerDriverService.Builder setBrowserExecutablePath(String browserPath, InternetExplorerDriverService.Builder builder) {
        if (browserPath != null) {
            log.warn("Non-null browser path configured for IE: '{}', but IEDriver does not support custom browser paths", (Object)browserPath);
        }
        return builder;
    }
}

