/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.webdriver.DefaultWebDriverContext;
import com.atlassian.webdriver.WebDriverContext;
import com.browserstack.local.Local;
import com.google.common.annotations.VisibleForTesting;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserstackWebDriverBuilder {
    private static final Logger log = LoggerFactory.getLogger(BrowserstackWebDriverBuilder.class);
    private static final String BROWSERSTACK_URL_PATTERN = "https://%s@hub-cloud.browserstack.com/wd/hub";
    private String username;
    private String authkey;
    private String browser;
    private String browserVersion;
    private String os;
    private String osVersion;
    private String projectCategoryName;
    private String testRunName;
    private String buildName;
    private String localIdentifier;
    private String acceptSslCerts;
    private String idleTimeout;
    private Local local;
    private String screenResolution;
    private String consoleLogs;
    private String networkLogs;
    private String visualLogs;
    private String videoLogs;
    private final Map<String, Object> moreCapabilities = new HashMap<String, Object>();

    public BrowserstackWebDriverBuilder(@Nonnull String username, @Nonnull String authkey) {
        this.withUser(username);
        this.withAuthkey(authkey);
    }

    public URL getServerUrl() {
        try {
            String userInfo = String.format("%s:%s", this.username, this.authkey);
            return new URL(String.format(BROWSERSTACK_URL_PATTERN, userInfo));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Browserstack URL could not be created", e);
        }
    }

    public BrowserstackWebDriverBuilder withBrowser(String browser) {
        this.browser = browser;
        return this;
    }

    public BrowserstackWebDriverBuilder withBrowserVersion(String version) {
        this.browserVersion = version;
        return this;
    }

    public BrowserstackWebDriverBuilder withOS(String os) {
        this.os = os;
        return this;
    }

    public BrowserstackWebDriverBuilder withOSVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public BrowserstackWebDriverBuilder withUser(@Nonnull String user) {
        this.username = user;
        return this;
    }

    public BrowserstackWebDriverBuilder withAuthkey(@Nonnull String authkey) {
        this.authkey = authkey;
        return this;
    }

    public BrowserstackWebDriverBuilder withProjectName(String property) {
        this.projectCategoryName = property;
        return this;
    }

    public BrowserstackWebDriverBuilder withTestName(String property) {
        this.testRunName = property;
        return this;
    }

    public BrowserstackWebDriverBuilder withBuildName(String property) {
        this.buildName = property;
        return this;
    }

    public BrowserstackWebDriverBuilder withIdleTimeout(String property) {
        this.idleTimeout = property;
        return this;
    }

    public BrowserstackWebDriverBuilder withLocalConnection(@Nullable Local local) {
        this.local = local;
        return this;
    }

    public BrowserstackWebDriverBuilder withLocalIdentifier(@Nullable String id) {
        this.localIdentifier = id;
        return this;
    }

    public BrowserstackWebDriverBuilder withAcceptSslCerts(@Nullable String acceptSslCerts) {
        this.acceptSslCerts = acceptSslCerts;
        return this;
    }

    public BrowserstackWebDriverBuilder withScreenResolution(String screenResolution) {
        this.screenResolution = screenResolution;
        return this;
    }

    public BrowserstackWebDriverBuilder withConsoleLogs(String consoleLogs) {
        this.consoleLogs = consoleLogs;
        return this;
    }

    public BrowserstackWebDriverBuilder withNetworkLogs(String networkLogs) {
        this.networkLogs = networkLogs;
        return this;
    }

    public BrowserstackWebDriverBuilder withVisualLogs(String visualLogs) {
        this.visualLogs = visualLogs;
        return this;
    }

    public BrowserstackWebDriverBuilder withVideoLogs(String videoLogs) {
        this.videoLogs = videoLogs;
        return this;
    }

    public BrowserstackWebDriverBuilder withCapability(String key, Object value) {
        this.moreCapabilities.put(key, value);
        return this;
    }

    public String getLocalIdentifier() {
        return this.localIdentifier;
    }

    public WebDriverContext build() throws Exception {
        URL serverUrl = this.getServerUrl();
        Browser browserType = Browser.typeOf((String)this.browser);
        DesiredCapabilities capabilities = this.buildCapabilities(browserType);
        RemoteWebDriver driver = new RemoteWebDriver(serverUrl, (Capabilities)capabilities);
        return new DefaultWebDriverContext((WebDriver)driver, browserType);
    }

    @VisibleForTesting
    DesiredCapabilities buildCapabilities(Browser browserType) throws Exception {
        DesiredCapabilities capabilities = BrowserstackWebDriverBuilder.getBaseCapabilities(browserType);
        Platform platform = capabilities.getPlatform() != null ? capabilities.getPlatform() : Platform.ANY;
        capabilities.setCapability("browser", capabilities.getBrowserName());
        capabilities.setCapability("browser_version", this.browserVersion);
        capabilities.setCapability("os", Optional.ofNullable(this.os).orElse(platform.name()));
        capabilities.setCapability("os_version", Optional.ofNullable(this.osVersion).orElse(String.valueOf(platform.getMajorVersion())));
        capabilities.setCapability("name", this.testRunName);
        capabilities.setCapability("project", Optional.ofNullable(this.projectCategoryName).orElse("atlassian-selenium"));
        capabilities.setCapability("build", Optional.ofNullable(this.buildName).orElseGet(() -> new Date().toString()));
        capabilities.setCapability("acceptSslCerts", Optional.ofNullable(this.acceptSslCerts).orElse("false"));
        this.setCapabilityIfNotNull(capabilities, "resolution", this.screenResolution);
        this.setCapabilityIfNotNull(capabilities, "browserstack.console", this.consoleLogs);
        this.setCapabilityIfNotNull(capabilities, "browserstack.networkLogs", this.networkLogs);
        this.setCapabilityIfNotNull(capabilities, "browserstack.debug", this.visualLogs);
        this.setCapabilityIfNotNull(capabilities, "browserstack.video", this.videoLogs);
        if (this.local != null) {
            HashMap<String, String> localOpts = new HashMap<String, String>();
            String localId = this.getLocalIdentifier();
            capabilities.setCapability("browserstack.local", "true");
            capabilities.setCapability("browserstack.localIdentifier", localId);
            localOpts.put("key", this.authkey);
            localOpts.put("localIdentifier", localId);
            this.local.start(localOpts);
        }
        capabilities.setCapability("browserstack.idleTimeout", Optional.ofNullable(this.idleTimeout).orElse("90"));
        this.moreCapabilities.forEach((arg_0, arg_1) -> ((DesiredCapabilities)capabilities).setCapability(arg_0, arg_1));
        return capabilities;
    }

    static DesiredCapabilities getBaseCapabilities(Browser browserType) {
        DesiredCapabilities capabilities;
        switch (browserType) {
            default: {
                log.error("Unknown browser: {}, defaulting to firefox.", (Object)browserType);
            }
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                break;
            }
            case CHROME: {
                capabilities = DesiredCapabilities.chrome();
                break;
            }
            case EDGE: {
                capabilities = DesiredCapabilities.edge();
                break;
            }
            case IE: {
                capabilities = DesiredCapabilities.internetExplorer();
                break;
            }
            case IPHONE: 
            case IPHONE_SIMULATOR: {
                capabilities = DesiredCapabilities.iphone();
                break;
            }
            case IPAD: {
                capabilities = DesiredCapabilities.ipad();
                break;
            }
            case ANDROID: 
            case ANDROID_EMULATOR: {
                capabilities = DesiredCapabilities.android();
                break;
            }
            case SAFARI: {
                capabilities = DesiredCapabilities.safari();
                break;
            }
            case OPERA: {
                capabilities = DesiredCapabilities.operaBlink();
            }
        }
        return capabilities;
    }

    private void setCapabilityIfNotNull(DesiredCapabilities capabilities, String propertyName, String value) {
        if (value != null) {
            capabilities.setCapability(propertyName, value);
        }
    }
}

