/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.visualcomparison;

import com.atlassian.selenium.visualcomparison.ScreenElement;
import com.atlassian.selenium.visualcomparison.v2.BrowserEngine;
import com.atlassian.selenium.visualcomparison.v2.settings.Resolution;
import com.atlassian.webdriver.debug.WebDriverDebug;
import com.atlassian.webdriver.utils.JavaScriptUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebDriverBrowserEngine
implements BrowserEngine {
    private static final Logger log = LoggerFactory.getLogger(WebDriverBrowserEngine.class);
    private final WebDriver webDriver;

    @Inject
    public WebDriverBrowserEngine(@Nonnull WebDriver webDriver) {
        this.webDriver = Objects.requireNonNull(webDriver, "webDriver");
    }

    @Nonnull
    public ScreenElement getElementAt(int x, int y) {
        try {
            ElementByPoint elementByPoint = new ElementByPoint(x, y).calculate();
            this.executeScript(Object.class, String.format("window.scrollTo(%d,%d)", elementByPoint.scrollTo.getX(), elementByPoint.scrollTo.getY()), new Object[0]);
            WebElement element = this.webDriver.findElement(this.byPoint(elementByPoint.elementCoordinates));
            return new SimpleScreenElement(this.executeScript(String.class, "var d = document.createElement('div'); d.appendChild(arguments[0].cloneNode(true)); return d.innerHTML;", element));
        }
        catch (Exception e) {
            log.error(String.format("Error while getting screen element at %d,%d", x, y), (Throwable)e);
            return new SimpleScreenElement("");
        }
    }

    @Nonnull
    public BrowserEngine resizeTo(@Nonnull Resolution resolution) {
        this.setSize(resolution);
        this.setSize(resolution);
        return this;
    }

    @Nonnull
    public BrowserEngine captureScreenshotTo(@Nonnull File file) {
        new WebDriverDebug(this.webDriver).takeScreenshotTo(file);
        return this;
    }

    @Nonnull
    public BrowserEngine reloadPage() {
        this.webDriver.navigate().refresh();
        return this;
    }

    @Nullable
    public <T> T executeScript(@Nonnull Class<T> returnType, @Nonnull String script, Object ... args) {
        return JavaScriptUtils.execute(returnType, script, this.webDriver, args);
    }

    private By byPoint(final Point coordinates) {
        return new By(){

            public List<WebElement> findElements(SearchContext context) {
                String findByPoint = String.format("return document.elementFromPoint(%d,%d);", coordinates.getX(), coordinates.getY());
                WebElement element = JavaScriptUtils.execute(WebElement.class, findByPoint, WebDriverBrowserEngine.this.webDriver, new Object[0]);
                return element != null ? Collections.singletonList(element) : Collections.emptyList();
            }

            public String toString() {
                return String.format("By point in viewport %d,%d", coordinates.getX(), coordinates.getY());
            }
        };
    }

    private Dimension getDimensionFor(String selector) {
        long x = this.executeScript(Long.class, "return jQuery(" + selector + ").width();", new Object[0]);
        long y = this.executeScript(Long.class, "return jQuery(" + selector + ").height();", new Object[0]);
        return new Dimension((int)x, (int)y);
    }

    private void setSize(Resolution resolution) {
        this.webDriver.manage().window().setSize(new Dimension(resolution.getWidth(), resolution.getHeight()));
    }

    private static final class SimpleScreenElement
    implements ScreenElement {
        private final String html;

        private SimpleScreenElement(@Nonnull String html) {
            this.html = html;
        }

        @Nonnull
        public String getHtml() {
            return this.html;
        }
    }

    private final class ElementByPoint {
        private final int x;
        private final int y;
        private Dimension viewport;
        private Dimension document;
        Point scrollTo;
        Point elementCoordinates;

        private ElementByPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        ElementByPoint calculate() {
            this.document = WebDriverBrowserEngine.this.getDimensionFor("document");
            this.viewport = WebDriverBrowserEngine.this.getDimensionFor("window");
            this.calculateScroll();
            this.calculateCoordinates();
            return this;
        }

        private void calculateScroll() {
            int deltaX = Math.max(0, this.document.getWidth() - this.viewport.getWidth());
            int scrollX = Math.min(this.x, deltaX);
            int deltaY = Math.max(0, this.document.getHeight() - this.viewport.getHeight());
            int scrollY = Math.min(this.y, deltaY);
            this.scrollTo = new Point(scrollX, scrollY);
        }

        private void calculateCoordinates() {
            int relativeX = this.x - this.scrollTo.getX();
            int relativeY = this.y - this.scrollTo.getY();
            this.elementCoordinates = new Point(relativeX, relativeY);
        }
    }
}

