/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.by;

import com.atlassian.webdriver.LifecycleAwareWebDriverGrid;
import com.atlassian.webdriver.utils.element.ElementLocated;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeferredBy
extends By {
    private static final Logger log = LoggerFactory.getLogger(DeferredBy.class);
    private static final int DEFERRED_BY_WAIT = 20;

    private static WebDriverWait getWait() {
        return new WebDriverWait(LifecycleAwareWebDriverGrid.getDriverContext().getDriver(), 20L);
    }

    private static DeferredBy by(final By selector) {
        if (selector == null) {
            throw new IllegalArgumentException("Cannot find elements with a null by selector");
        }
        return new DeferredBy(){

            public List<WebElement> findElements(SearchContext context) {
                try {
                    DeferredBy.getWait().until((Function)((Object)new ElementLocated(selector)));
                    return context.findElements(selector);
                }
                catch (TimeoutException e) {
                    log.error("DeferredBy was unable to findElements using the selector: " + selector);
                    throw e;
                }
            }

            public WebElement findElement(SearchContext context) {
                try {
                    DeferredBy.getWait().until((Function)((Object)new ElementLocated(selector)));
                    return context.findElement(selector);
                }
                catch (TimeoutException e) {
                    log.error("DeferredBy was unable to findElement using the selector: " + selector);
                    throw e;
                }
            }

            public String toString() {
                return "DeferredBy(" + super.toString() + ")";
            }
        };
    }

    public static DeferredBy id(String id) {
        return DeferredBy.by(By.id((String)id));
    }

    public static By linkText(String linkText) {
        return DeferredBy.by(By.linkText((String)linkText));
    }

    public static By partialLinkText(String linkText) {
        return DeferredBy.by(By.partialLinkText((String)linkText));
    }

    public static By name(String name) {
        return DeferredBy.by(By.name((String)name));
    }

    public static By tagName(String name) {
        return DeferredBy.by(By.tagName((String)name));
    }

    public static By xpath(String xpathExpression) {
        return DeferredBy.by(By.xpath((String)xpathExpression));
    }

    public static By className(String className) {
        return DeferredBy.by(By.className((String)className));
    }

    public static By cssSelector(String selector) {
        return DeferredBy.by(By.cssSelector((String)selector));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeferredBy by = (DeferredBy)((Object)o);
        return this.toString().equals(by.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

