/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public final class WebDriverUtil {
    private WebDriverUtil() {
        throw new AssertionError((Object)(WebDriverUtil.class.getName() + " is not supposed to be instantiated"));
    }

    public static boolean isFirefox(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof FirefoxDriver;
    }

    public static boolean isChrome(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof ChromeDriver;
    }

    public static boolean isIE(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof InternetExplorerDriver;
    }

    @Nonnull
    public static WebDriver getUnderlyingDriver(@Nonnull WebDriver driver) {
        Objects.requireNonNull(driver, "driver");
        while (driver instanceof WrapsDriver) {
            driver = ((WrapsDriver)driver).getWrappedDriver();
        }
        return driver;
    }

    public static boolean isInstance(@Nonnull WebDriver driver, @Nonnull Class<?> type) {
        return type.isInstance(WebDriverUtil.getUnderlyingDriver(driver));
    }

    public static <T> T as(@Nonnull WebDriver driver, @Nonnull Class<T> type) {
        return type.cast(WebDriverUtil.getUnderlyingDriver(driver));
    }

    @Nonnull
    public static DesiredCapabilities createCapabilitiesFromString(@Nullable String capabilitiesList) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        if (!StringUtils.isEmpty((CharSequence)capabilitiesList)) {
            for (String cap : capabilitiesList.split(";")) {
                String[] nameVal = cap.split("=");
                capabilities.setCapability(nameVal[0], nameVal[1]);
            }
        }
        return capabilities;
    }
}

