/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JavaScriptUtils {
    private JavaScriptUtils() {
    }

    public static void dispatchEvent(String eventType, WebElement element, WebDriver webDriver) {
        JavaScriptUtils.execute("arguments[0].dispatchEvent(typeof (Event) === 'function' ? new Event(arguments[1]) : (function (ev) {\n    var tmp = document.createEvent('Event');\n    tmp.initEvent(ev, true, true);\n    return tmp;\n})(arguments[1]));", webDriver, element, eventType);
    }

    public static void dispatchMouseEvent(String event, WebElement el, WebDriver driver) {
        JavaScriptUtils.dispatchEvent(event, el, driver);
    }

    public static <T> T execute(String js, WebDriver driver, Object ... arguments) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        return (T)jsExecutor.executeScript(js, arguments);
    }

    public static <T> T execute(Class<T> expectedReturn, String js, WebDriver driver, Object ... arguments) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        Object result = jsExecutor.executeScript(js, arguments);
        if (result != null && !expectedReturn.isInstance(result)) {
            throw new ClassCastException("Expected result type " + expectedReturn.getName() + " but was: " + result.getClass().getName());
        }
        return expectedReturn.cast(result);
    }
}

