/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.debug.WebDriverDebug;
import com.atlassian.webdriver.testing.rule.WebDriverSupport;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverScreenshotRule
extends TestWatcher {
    private static final Logger log = LoggerFactory.getLogger(WebDriverScreenshotRule.class);
    private final WebDriverDebug debug;
    private final File artifactDir;

    private static File defaultArtifactDir() {
        return new File("target/webdriverTests");
    }

    protected WebDriverScreenshotRule(@Nonnull WebDriverDebug webDriverDebug, @Nonnull File artifactDir) {
        this.debug = Objects.requireNonNull(webDriverDebug, "webDriverDebug");
        this.artifactDir = Objects.requireNonNull(artifactDir, "artifactDir");
    }

    protected WebDriverScreenshotRule(@Nonnull WebDriverSupport<? extends WebDriver> support, @Nonnull File artifactDir) {
        this(new WebDriverDebug(Objects.requireNonNull(support, "support").getDriver()), artifactDir);
    }

    public WebDriverScreenshotRule(@Nonnull Supplier<? extends WebDriver> driverSupplier) {
        this(WebDriverSupport.forSupplier(driverSupplier), WebDriverScreenshotRule.defaultArtifactDir());
    }

    public WebDriverScreenshotRule(@Nonnull WebDriver webDriver) {
        this(WebDriverSupport.forInstance(webDriver), WebDriverScreenshotRule.defaultArtifactDir());
    }

    @Inject
    public WebDriverScreenshotRule(@Nonnull WebDriverDebug webDriverDebug) {
        this(webDriverDebug, WebDriverScreenshotRule.defaultArtifactDir());
    }

    public WebDriverScreenshotRule() {
        this(WebDriverSupport.fromAutoInstall(), WebDriverScreenshotRule.defaultArtifactDir());
    }

    public WebDriverScreenshotRule artifactDir(File artifactDir) {
        return new WebDriverScreenshotRule(this.debug, artifactDir);
    }

    protected void starting(@Nonnull Description description) {
        File dir = this.getTargetDir(description);
        if (!dir.exists()) {
            Preconditions.checkState((boolean)dir.mkdirs(), (Object)("Unable to create screenshot output directory " + dir.getAbsolutePath()));
        }
    }

    protected void failed(@Nonnull Throwable e, @Nonnull Description description) {
        File dumpFile = this.getTargetFile(description, "html");
        File screenShotFile = this.getTargetFile(description, "png");
        log.info("----- {} failed. ", (Object)description.getDisplayName());
        log.info("----- At page: " + this.debug.getCurrentUrl());
        log.info("----- Dumping page source to {} and screenshot to {}", (Object)dumpFile.getAbsolutePath(), (Object)screenShotFile.getAbsolutePath());
        this.debug.dumpSourceTo(dumpFile);
        this.debug.takeScreenshotTo(screenShotFile);
    }

    public void takeManualScreenshotAndSource(Description description) {
        File dumpFile = this.getTargetFile(description, "html");
        File screenShotFile = this.getTargetFile(description, "png");
        log.info("----- {} manually triggered dumping page source to {} and screenshot to {}", new Object[]{description.getMethodName(), dumpFile.getAbsolutePath(), screenShotFile.getAbsolutePath()});
        this.debug.dumpSourceTo(dumpFile);
        this.debug.takeScreenshotTo(screenShotFile);
    }

    public void takeManualScreenshotAndSource(String className, String methodName) {
        this.takeManualScreenshotAndSource(Description.createTestDescription((String)className, (String)methodName, (Annotation[])new Annotation[0]));
    }

    private File getTargetDir(Description description) {
        return new File(this.artifactDir, description.getClassName());
    }

    private File getTargetFile(Description description, String extension) {
        File file = new File(this.getTargetDir(description), description.getMethodName() + "." + extension);
        int fileNum = 1;
        while (file.exists()) {
            file = new File(this.getTargetDir(description), description.getMethodName() + "-" + fileNum++ + "." + extension);
        }
        return file;
    }
}

