/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.fugue.Suppliers;
import com.atlassian.webdriver.browsers.WebDriverBrowserAutoInstall;
import com.atlassian.webdriver.utils.WebDriverUtil;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

public class LocalFileDetectorRule
implements TestRule {
    private final Supplier<? extends WebDriver> webDriver;

    public LocalFileDetectorRule(WebDriver webDriver) {
        this((Supplier<? extends WebDriver>)Suppliers.ofInstance((Object)webDriver));
    }

    public LocalFileDetectorRule(Supplier<? extends WebDriver> webDriver) {
        this.webDriver = webDriver;
    }

    public LocalFileDetectorRule() {
        this.webDriver = WebDriverBrowserAutoInstall.driverSupplier();
    }

    public Statement apply(final Statement base, Description description) {
        final WebDriver driver = WebDriverUtil.getUnderlyingDriver(this.webDriver.get());
        if (!(driver instanceof RemoteWebDriver)) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                RemoteWebDriver remoteWebDriver = (RemoteWebDriver)driver;
                FileDetector previous = remoteWebDriver.getFileDetector();
                remoteWebDriver.setFileDetector((FileDetector)new LocalFileDetector());
                try {
                    base.evaluate();
                }
                finally {
                    remoteWebDriver.setFileDetector(previous);
                }
            }
        };
    }
}

