/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.debug;

import com.atlassian.webdriver.debug.JavaScriptErrorInfo;
import com.atlassian.webdriver.debug.JavaScriptErrorInfoImpl;
import com.atlassian.webdriver.debug.JavaScriptErrorRetriever;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FirefoxLogParsingJavaScriptErrorRetriever
implements JavaScriptErrorRetriever {
    private static final Logger log = LoggerFactory.getLogger(FirefoxLogParsingJavaScriptErrorRetriever.class);
    private static final String DEFAULT_ERROR_REGEX = "(?:console\\.error|JavaScript error): (?<error>.*)";
    private static final String REGEX_GROUP_NAME = "error";
    private Pattern pattern = Pattern.compile("(?:console\\.error|JavaScript error): (?<error>.*)", 66);
    private final String filePath;
    int alreadyProcessedLines = 0;

    public FirefoxLogParsingJavaScriptErrorRetriever(@Nullable String filePath) {
        this.filePath = filePath;
    }

    public FirefoxLogParsingJavaScriptErrorRetriever(@Nullable String filePath, @Nullable Pattern pattern) {
        this.filePath = filePath;
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    @Override
    public boolean isErrorRetrievalSupported() {
        return this.filePath != null;
    }

    @Override
    public Iterable<JavaScriptErrorInfo> getErrors() {
        if (this.filePath == null) {
            log.warn("getErrors() called with empty 'filePath', have 'isErrorRetrievalSupported' been called prior this invocation ?");
            return Collections.emptyList();
        }
        log.debug("Getting console logs from file: {} and skipping {}", (Object)this.filePath, (Object)this.alreadyProcessedLines);
        try {
            Path path = Paths.get(this.filePath, new String[0]);
            return Files.lines(path).skip(this.alreadyProcessedLines).map(line -> {
                ++this.alreadyProcessedLines;
                return line;
            }).map(line -> this.pattern.matcher((CharSequence)line)).filter(Matcher::find).map(matcher -> matcher.group(REGEX_GROUP_NAME)).map(line -> new JavaScriptErrorInfoImpl((String)line, (String)line)).collect(Collectors.toList());
        }
        catch (IOException | SecurityException e) {
            log.error("Error during processing firefox log file {}", (Object)this.filePath, (Object)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    public static String getFilePathFromSystemProperty() {
        return System.getProperty("webdriver.firefox.logfile");
    }

    public static Pattern getLogRegexPatternFromSystemProperty() {
        String regex = System.getProperty("webdriver.firefox.devtools.console.regex", DEFAULT_ERROR_REGEX);
        if (!regex.isEmpty()) {
            return Pattern.compile(regex, 66);
        }
        return Pattern.compile(DEFAULT_ERROR_REGEX, 66);
    }
}

