/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.chrome;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.webdriver.WebDriverFactory;
import com.atlassian.webdriver.WebDriverProperties;
import com.atlassian.webdriver.browsers.AbstractBrowser;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeBrowser
extends AbstractBrowser<ChromeDriver> {
    private static final Logger log = LoggerFactory.getLogger(ChromeBrowser.class);

    public static ChromeDriver getDriver(BrowserConfig browserConfig, String browserPath, @Nullable Capabilities capabilities) {
        return (ChromeDriver)ChromeBrowser.getDriver(ChromeBrowser.class, browserConfig, browserPath, capabilities);
    }

    @Override
    public ChromeDriver getDriver(@Nullable Capabilities capabilities) {
        return new ChromeDriver(new ChromeOptions().merge(capabilities));
    }

    @Override
    public ChromeDriver getDriver(BrowserConfig browserConfig, @Nullable Capabilities capabilities) {
        if (browserConfig != null) {
            ChromeOptions options = new ChromeOptions();
            options.merge(capabilities);
            options.setBinary(browserConfig.getBinaryPath());
            ChromeBrowser.setDefaultArgs(options);
            ChromeBrowser.addCommandLine(options);
            ChromeBrowser.updateOptions(options);
            ChromeDriverService.Builder chromeServiceBuilder = new ChromeDriverService.Builder();
            ChromeBrowser.setChromeServicePath(browserConfig, chromeServiceBuilder);
            ChromeBrowser.setEnvironment(chromeServiceBuilder);
            chromeServiceBuilder.usingAnyFreePort();
            ChromeDriverService chromeDriverService = (ChromeDriverService)chromeServiceBuilder.build();
            return new ChromeDriver(chromeDriverService, options);
        }
        return this.getDriver(capabilities);
    }

    @Override
    public ChromeDriver getDriver(String browserPath, @Nullable Capabilities capabilities) {
        if (browserPath != null) {
            ChromeOptions options = new ChromeOptions();
            options.merge(capabilities);
            options.setBinary(browserPath);
            ChromeBrowser.updateOptions(options);
            return new ChromeDriver(options);
        }
        log.info("Browser path was null, falling back to default chrome driver.");
        return this.getDriver(capabilities);
    }

    public static void updateOptions(ChromeOptions options) {
        options.setHeadless(WebDriverFactory.isBrowserHeadless());
        options.setExperimentalOption("w3c", (Object)false);
    }

    private static void setDefaultArgs(ChromeOptions options) {
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
    }

    private static void setChromeServicePath(BrowserConfig browserConfig, ChromeDriverService.Builder chromeServiceBuilder) {
        File profilePath;
        File chromeDriverFile;
        if (browserConfig.getProfilePath() != null && (chromeDriverFile = new File(profilePath = new File(browserConfig.getProfilePath()), "chromedriver" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""))).exists()) {
            chromeServiceBuilder.usingDriverExecutable(chromeDriverFile);
        }
    }

    private static void addCommandLine(ChromeOptions options) {
        String[] switches = StringUtils.split((String)WebDriverProperties.WEBDRIVER_CHROME_SWITCHES.getSystemProperty(), (String)",");
        if (switches != null && switches.length > 0) {
            List<String> switchList = Arrays.asList(switches);
            log.info("Setting command line arguments for Chrome: " + switchList);
            options.addArguments(switchList);
        }
    }

    private static void setEnvironment(ChromeDriverService.Builder chromeDriverServiceBuilder) {
        HashMap env = Maps.newHashMap();
        String DISPLAY = "DISPLAY";
        if (System.getProperty("DISPLAY") != null) {
            env.put("DISPLAY", System.getProperty("DISPLAY"));
        }
        chromeDriverServiceBuilder.withEnvironment((Map)env);
    }
}

